/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.AlertListener;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraDialogSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraAlertSkin
extends TerraDialogSkin
implements AlertListener {
    private ImageView typeImageView = null;
    private Label messageLabel = null;
    private BoxPane messageBoxPane = null;
    private BoxPane optionButtonBoxPane = null;
    private ButtonPressListener optionButtonPressListener = new ButtonPressListener(){

        public void buttonPressed(Button button) {
            int optionIndex = TerraAlertSkin.this.optionButtonBoxPane.indexOf((Component)button);
            if (optionIndex >= 0) {
                Alert alert = (Alert)TerraAlertSkin.this.getComponent();
                alert.setSelectedOptionIndex(optionIndex);
                alert.close(true);
            }
        }
    };

    public TerraAlertSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(9));
    }

    @Override
    public void install(Component component) {
        Component content;
        super.install(component);
        Alert alert = (Alert)component;
        alert.setPreferredWidth(320);
        alert.setMinimumWidth(160);
        alert.getAlertListeners().add((Object)this);
        BXMLSerializer bxmlSerializer = new BXMLSerializer();
        try {
            content = (Component)bxmlSerializer.readObject(TerraAlertSkin.class, "terra_alert_skin.bxml");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        alert.setContent(content);
        this.typeImageView = (ImageView)bxmlSerializer.getNamespace().get((Object)"typeImageView");
        this.messageLabel = (Label)bxmlSerializer.getNamespace().get((Object)"messageLabel");
        this.messageBoxPane = (BoxPane)bxmlSerializer.getNamespace().get((Object)"messageBoxPane");
        this.optionButtonBoxPane = (BoxPane)bxmlSerializer.getNamespace().get((Object)"optionButtonBoxPane");
        for (Object option : alert.getOptions()) {
            PushButton optionButton = new PushButton(option);
            optionButton.setStyleName(TerraAlertSkin.class.getPackage().getName() + "." + "commandButton");
            optionButton.getButtonPressListeners().add((Object)this.optionButtonPressListener);
            this.optionButtonBoxPane.add((Component)optionButton);
        }
        this.messageTypeChanged(alert, null);
        this.messageChanged(alert, null);
        this.bodyChanged(alert, null);
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        Alert alert = (Alert)window;
        int index = alert.getSelectedOptionIndex();
        if (index >= 0) {
            this.optionButtonBoxPane.get(index).requestFocus();
        } else {
            window.requestFocus();
        }
    }

    public void messageTypeChanged(Alert alert, MessageType previousMessageType) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.typeImageView.setImage(theme.getMessageIcon(alert.getMessageType()));
    }

    public void messageChanged(Alert alert, String previousMessage) {
        this.messageLabel.setText(alert.getMessage());
    }

    public void bodyChanged(Alert alert, Component previousBody) {
        Component body;
        if (previousBody != null) {
            this.messageBoxPane.remove(previousBody);
        }
        if ((body = alert.getBody()) != null) {
            this.messageBoxPane.add(body);
        }
    }

    public void optionInserted(Alert alert, int index) {
        Object option = alert.getOptions().get(index);
        PushButton optionButton = new PushButton(option);
        optionButton.setStyleName(TerraAlertSkin.class.getPackage().getName() + "." + "commandButton");
        optionButton.getButtonPressListeners().add((Object)this.optionButtonPressListener);
        this.optionButtonBoxPane.insert((Component)optionButton, index);
    }

    public void optionsRemoved(Alert alert, int index, Sequence<?> removed) {
        this.optionButtonBoxPane.remove(index, removed.getLength());
    }

    public void selectedOptionChanged(Alert alert, int previousSelectedOption) {
        int index = alert.getSelectedOptionIndex();
        if (alert.isOpen() && index >= 0) {
            this.optionButtonBoxPane.get(index).requestFocus();
        }
    }

    public Vote previewWindowOpen(Window window) {
        Vote vote = super.previewWindowOpen(window);
        switch (vote) {
            case APPROVE: {
                this.messageTypeChanged((Alert)window, null);
            }
        }
        return vote;
    }

    @Override
    public void dialogClosed(Dialog dialog, boolean modal) {
        super.dialogClosed(dialog, modal);
        this.typeImageView.clearImage();
    }
}

