/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.charts;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.charts.ChartViewCategoryListener;
import org.apache.pivot.charts.ChartViewListener;
import org.apache.pivot.charts.ChartViewSeriesListener;
import org.apache.pivot.charts.Provider;
import org.apache.pivot.charts.ProviderNotFoundException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Service;
import org.apache.pivot.wtk.Component;

@DefaultProperty(value="chartData")
public abstract class ChartView
extends Component {
    private List<?> chartData;
    private String seriesNameKey;
    private String title = null;
    private String horizontalAxisLabel = null;
    private String verticalAxisLabel = null;
    private boolean showLegend;
    private ArrayList<Category> categories = new ArrayList();
    private CategorySequence categorySequence = new CategorySequence();
    private ListHandler chartDataHandler = new ListHandler();
    private ChartViewListenerList chartViewListeners = new ChartViewListenerList();
    private ChartViewCategoryListenerList chartViewCategoryListeners = new ChartViewCategoryListenerList();
    private ChartViewSeriesListenerList chartViewSeriesListeners = new ChartViewSeriesListenerList();
    public static final String DEFAULT_SERIES_NAME_KEY = "name";
    public static final String PROVIDER_NAME = Provider.class.getName();
    private static Provider provider = null;

    public ChartView() {
        this(DEFAULT_SERIES_NAME_KEY, (List<?>)new ArrayList());
    }

    public ChartView(String seriesNameKey, List<?> chartData) {
        this.setSeriesNameKey(seriesNameKey);
        this.setTitle(this.title);
        this.setChartData(chartData);
        this.setShowLegend(this.showLegend);
    }

    protected void installSkin(Class<? extends Component> componentClass) {
        Class<? extends org.apache.pivot.wtk.Skin> skinClass = provider.getSkinClass(componentClass);
        try {
            this.setSkin(skinClass.newInstance());
        }
        catch (InstantiationException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public CategorySequence getCategories() {
        return this.categorySequence;
    }

    public List<?> getChartData() {
        return this.chartData;
    }

    public void setChartData(List<?> chartData) {
        if (chartData == null) {
            throw new IllegalArgumentException("chartData is null.");
        }
        List<?> previousChartData = this.chartData;
        if (previousChartData != chartData) {
            if (previousChartData != null) {
                previousChartData.getListListeners().remove((Object)this.chartDataHandler);
            }
            chartData.getListListeners().add((Object)this.chartDataHandler);
            this.chartData = chartData;
            this.chartViewListeners.chartDataChanged(this, previousChartData);
        }
    }

    public String getSeriesNameKey() {
        return this.seriesNameKey;
    }

    public void setSeriesNameKey(String seriesNameKey) {
        if (seriesNameKey == null) {
            throw new IllegalArgumentException("seriesNameKey is null.");
        }
        String previousSeriesNameKey = this.seriesNameKey;
        if (previousSeriesNameKey != seriesNameKey) {
            this.seriesNameKey = seriesNameKey;
            this.chartViewListeners.seriesNameKeyChanged(this, previousSeriesNameKey);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String previousTitle = this.title;
        if (previousTitle != title) {
            this.title = title;
            this.chartViewListeners.titleChanged(this, previousTitle);
        }
    }

    public String getHorizontalAxisLabel() {
        return this.horizontalAxisLabel;
    }

    public void setHorizontalAxisLabel(String horizontalAxisLabel) {
        String previousHorizontalAxisLabel = this.horizontalAxisLabel;
        if (previousHorizontalAxisLabel != horizontalAxisLabel) {
            this.horizontalAxisLabel = horizontalAxisLabel;
            this.chartViewListeners.horizontalAxisLabelChanged(this, previousHorizontalAxisLabel);
        }
    }

    public String getVerticalAxisLabel() {
        return this.verticalAxisLabel;
    }

    public void setVerticalAxisLabel(String verticalAxisLabel) {
        String previousVerticalAxisLabel = this.verticalAxisLabel;
        if (previousVerticalAxisLabel != verticalAxisLabel) {
            this.verticalAxisLabel = verticalAxisLabel;
            this.chartViewListeners.verticalAxisLabelChanged(this, previousVerticalAxisLabel);
        }
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        if (this.showLegend != showLegend) {
            this.showLegend = showLegend;
            this.chartViewListeners.showLegendChanged(this);
        }
    }

    public Element getElementAt(int x, int y) {
        return ((Skin)this.getSkin()).getElementAt(x, y);
    }

    public ListenerList<ChartViewListener> getChartViewListeners() {
        return this.chartViewListeners;
    }

    public ListenerList<ChartViewCategoryListener> getChartViewCategoryListeners() {
        return this.chartViewCategoryListeners;
    }

    public ListenerList<ChartViewSeriesListener> getChartViewSeriesListeners() {
        return this.chartViewSeriesListeners;
    }

    static {
        provider = (Provider)Service.getProvider((String)PROVIDER_NAME);
        if (provider == null) {
            throw new ProviderNotFoundException();
        }
    }

    private static class ChartViewSeriesListenerList
    extends ListenerList<ChartViewSeriesListener>
    implements ChartViewSeriesListener {
        private ChartViewSeriesListenerList() {
        }

        @Override
        public void seriesInserted(ChartView chartView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewSeriesListener listener = (ChartViewSeriesListener)i$.next();
                listener.seriesInserted(chartView, index);
            }
        }

        @Override
        public void seriesRemoved(ChartView chartView, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewSeriesListener listener = (ChartViewSeriesListener)i$.next();
                listener.seriesRemoved(chartView, index, count);
            }
        }

        @Override
        public void seriesUpdated(ChartView chartView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewSeriesListener listener = (ChartViewSeriesListener)i$.next();
                listener.seriesUpdated(chartView, index);
            }
        }

        @Override
        public void seriesCleared(ChartView chartView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewSeriesListener listener = (ChartViewSeriesListener)i$.next();
                listener.seriesCleared(chartView);
            }
        }

        @Override
        public void seriesSorted(ChartView chartView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewSeriesListener listener = (ChartViewSeriesListener)i$.next();
                listener.seriesSorted(chartView);
            }
        }
    }

    private static class ChartViewCategoryListenerList
    extends ListenerList<ChartViewCategoryListener>
    implements ChartViewCategoryListener {
        private ChartViewCategoryListenerList() {
        }

        @Override
        public void categoryInserted(ChartView chartView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewCategoryListener listener = (ChartViewCategoryListener)i$.next();
                listener.categoryInserted(chartView, index);
            }
        }

        @Override
        public void categoriesRemoved(ChartView chartView, int index, Sequence<Category> categories) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewCategoryListener listener = (ChartViewCategoryListener)i$.next();
                listener.categoriesRemoved(chartView, index, categories);
            }
        }

        @Override
        public void categoryKeyChanged(ChartView chartView, int index, String previousKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewCategoryListener listener = (ChartViewCategoryListener)i$.next();
                listener.categoryKeyChanged(chartView, index, previousKey);
            }
        }

        @Override
        public void categoryLabelChanged(ChartView chartView, int index, String previousLabel) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewCategoryListener listener = (ChartViewCategoryListener)i$.next();
                listener.categoryLabelChanged(chartView, index, previousLabel);
            }
        }
    }

    private static class ChartViewListenerList
    extends ListenerList<ChartViewListener>
    implements ChartViewListener {
        private ChartViewListenerList() {
        }

        @Override
        public void chartDataChanged(ChartView chartView, List<?> previousChartData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.chartDataChanged(chartView, previousChartData);
            }
        }

        @Override
        public void seriesNameKeyChanged(ChartView chartView, String previousSeriesNameKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.seriesNameKeyChanged(chartView, previousSeriesNameKey);
            }
        }

        @Override
        public void titleChanged(ChartView chartView, String previousTitle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.titleChanged(chartView, previousTitle);
            }
        }

        @Override
        public void horizontalAxisLabelChanged(ChartView chartView, String previousXAxisLabel) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.horizontalAxisLabelChanged(chartView, previousXAxisLabel);
            }
        }

        @Override
        public void verticalAxisLabelChanged(ChartView chartView, String previousYAxisLabel) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.verticalAxisLabelChanged(chartView, previousYAxisLabel);
            }
        }

        @Override
        public void showLegendChanged(ChartView chartView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ChartViewListener listener = (ChartViewListener)i$.next();
                listener.showLegendChanged(chartView);
            }
        }
    }

    private class ListHandler
    implements ListListener<Object> {
        private ListHandler() {
        }

        public void itemInserted(List<Object> list, int index) {
            ChartView.this.chartViewSeriesListeners.seriesInserted(ChartView.this, index);
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int count = items.getLength();
            ChartView.this.chartViewSeriesListeners.seriesRemoved(ChartView.this, index, count);
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            ChartView.this.chartViewSeriesListeners.seriesUpdated(ChartView.this, index);
        }

        public void listCleared(List<Object> list) {
            ChartView.this.chartViewSeriesListeners.seriesCleared(ChartView.this);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                ChartView.this.chartViewSeriesListeners.seriesSorted(ChartView.this);
            }
        }
    }

    public final class CategorySequence
    implements Sequence<Category> {
        public int add(Category category) {
            int index = this.getLength();
            this.insert(category, index);
            return index;
        }

        public void insert(Category category, int index) {
            if (category == null) {
                throw new IllegalArgumentException("category is null.");
            }
            if (category.getChartView() != null) {
                throw new IllegalArgumentException("category is already in use by another chart view.");
            }
            ChartView.this.categories.insert((Object)category, index);
            category.chartView = ChartView.this;
            ChartView.this.chartViewCategoryListeners.categoryInserted(ChartView.this, index);
        }

        public Category update(int index, Category category) {
            throw new UnsupportedOperationException();
        }

        public int remove(Category category) {
            int index = this.indexOf(category);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Category> remove(int index, int count) {
            Sequence removed = ChartView.this.categories.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    ((Category)removed.get(i)).chartView = null;
                }
                ChartView.this.chartViewCategoryListeners.categoriesRemoved(ChartView.this, index, (Sequence<Category>)removed);
            }
            return removed;
        }

        public Category get(int index) {
            return (Category)ChartView.this.categories.get(index);
        }

        public int indexOf(Category category) {
            return ChartView.this.categories.indexOf((Object)category);
        }

        public int getLength() {
            return ChartView.this.categories.getLength();
        }
    }

    public static interface Skin {
        public Element getElementAt(int var1, int var2);
    }

    public static class Element {
        private int seriesIndex;
        private int elementIndex;

        public Element(int seriesIndex, int elementIndex) {
            this.seriesIndex = seriesIndex;
            this.elementIndex = elementIndex;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public int getElementIndex() {
            return this.elementIndex;
        }

        public String toString() {
            String string = this.getClass().getName() + this.seriesIndex + ", " + this.elementIndex;
            return string;
        }
    }

    public static class Category {
        private ChartView chartView = null;
        private String key;
        private String label;

        public Category() {
            this(null, null);
        }

        public Category(String key) {
            this(key, key);
        }

        public Category(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public ChartView getChartView() {
            return this.chartView;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            if (key == null) {
                throw new IllegalArgumentException("key is null.");
            }
            String previousKey = this.key;
            if (previousKey != key) {
                this.key = key;
                if (this.chartView != null) {
                    this.chartView.chartViewCategoryListeners.categoryKeyChanged(this.chartView, this.chartView.categories.indexOf((Object)this), previousKey);
                }
            }
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            if (label == null) {
                throw new IllegalArgumentException("label is null.");
            }
            String previousLabel = this.label;
            if (previousLabel != label) {
                this.label = label;
                if (this.chartView != null) {
                    this.chartView.chartViewCategoryListeners.categoryLabelChanged(this.chartView, this.chartView.categories.indexOf((Object)this), previousLabel);
                }
            }
        }
    }
}

