/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pivot.collections.HashSet;

public class ProxyServlet
extends HttpServlet {
    private String hostname = null;
    private int port = -1;
    private String path = null;
    private static ResponseHeaderSet ignoreResponseHeaders = new ResponseHeaderSet();
    private static final long serialVersionUID = -1794977331184160392L;
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String HOSTNAME_PARAM = "hostname";
    public static final String PORT_PARAM = "port";
    public static final String PATH_PARAM = "path";
    public static final int BUFFER_SIZE = 1024;

    public void init(ServletConfig config) throws ServletException {
        super.init();
        this.hostname = config.getInitParameter(HOSTNAME_PARAM);
        if (this.hostname == null) {
            throw new ServletException("Hostname is required.");
        }
        String portHeader = config.getInitParameter(PORT_PARAM);
        this.port = portHeader == null ? -1 : Integer.parseInt(portHeader);
        this.path = config.getInitParameter(PATH_PARAM);
        if (this.path == null) {
            throw new ServletException("Path is required.");
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int status;
        int statusPrefix;
        String queryString;
        String pathLocal = this.path;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            pathLocal = pathLocal + "/" + pathInfo;
        }
        if ((queryString = request.getQueryString()) != null) {
            pathLocal = pathLocal + "?" + queryString;
        }
        URL url = null;
        try {
            url = new URL(request.getScheme(), this.hostname, this.port, pathLocal);
        }
        catch (MalformedURLException exception) {
            throw new ServletException("Unable to construct URL.", (Throwable)exception);
        }
        String method = request.getMethod();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (connection.getRequestProperty(headerName) == null) {
                        connection.setRequestProperty(headerName, headerValue);
                        continue;
                    }
                    connection.addRequestProperty(headerName, headerValue);
                }
            }
        }
        connection.setDoInput(true);
        connection.setDoOutput(method.equalsIgnoreCase(METHOD_POST) || method.equalsIgnoreCase(METHOD_PUT));
        connection.connect();
        if (connection.getDoOutput()) {
            OutputStream outputStream = null;
            try {
                ServletInputStream inputStream = request.getInputStream();
                outputStream = connection.getOutputStream();
                outputStream = new BufferedOutputStream(outputStream, 1024);
                int data = inputStream.read();
                while (data != -1) {
                    outputStream.write((byte)data);
                    data = inputStream.read();
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        if ((statusPrefix = (status = connection.getResponseCode()) / 100) == 1 || statusPrefix == 3) {
            throw new ServletException("Unexpected server response: " + status);
        }
        response.setStatus(status);
        int i = 1;
        String key = connection.getHeaderFieldKey(i);
        while (key != null) {
            if (!ignoreResponseHeaders.contains(key)) {
                String value = connection.getHeaderField(i);
                if (response.containsHeader(key)) {
                    response.addHeader(key, value);
                } else {
                    response.setHeader(key, value);
                }
            }
            key = connection.getHeaderFieldKey(++i);
        }
        if (method.equalsIgnoreCase(METHOD_GET)) {
            InputStream inputStream = null;
            try {
                try {
                    inputStream = connection.getInputStream();
                }
                catch (Exception exception) {
                    inputStream = connection.getErrorStream();
                }
                if (inputStream != null) {
                    inputStream = new BufferedInputStream(inputStream, 1024);
                    ServletOutputStream outputStream = response.getOutputStream();
                    int data = inputStream.read();
                    while (data != -1) {
                        outputStream.write((byte)data);
                        data = inputStream.read();
                    }
                }
                response.flushBuffer();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    static {
        ignoreResponseHeaders.add("Transfer-Encoding");
    }

    private static class ResponseHeaderSet
    extends HashSet<String> {
        private static final long serialVersionUID = 3055851700567335445L;

        private ResponseHeaderSet() {
        }

        public boolean add(String element) {
            return super.add((Object)element.toLowerCase());
        }

        public boolean remove(String element) {
            return super.remove((Object)element.toLowerCase());
        }

        public boolean contains(String element) {
            return super.contains((Object)element.toLowerCase());
        }
    }
}

