/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.xml.Element;
import org.apache.pivot.xml.Node;
import org.apache.pivot.xml.TextNode;
import org.apache.pivot.xml.XMLSerializerListener;

public class XMLSerializer
implements Serializer<Element> {
    private Charset charset = null;
    private XMLSerializerListenerList xmlSerializerListeners = null;
    public static final String XMLNS_ATTRIBUTE_PREFIX = "xmlns";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String XML_EXTENSION = "xml";
    public static final String MIME_TYPE = "text/xml";
    public static final int BUFFER_SIZE = 2048;

    public XMLSerializer() {
        this(Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public XMLSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Element readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        Element element = this.readObject(reader);
        return element;
    }

    public Element readObject(Reader reader) throws SerializationException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        Element document = null;
        try {
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            Node current = null;
            block7: while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                switch (event) {
                    case 4: {
                        if (xmlStreamReader.isWhiteSpace()) break;
                        TextNode textNode = new TextNode(xmlStreamReader.getText());
                        if (this.xmlSerializerListeners != null) {
                            this.xmlSerializerListeners.readTextNode(this, textNode);
                        }
                        if (current == null) continue block7;
                        ((Element)current).add(textNode);
                        break;
                    }
                    case 1: {
                        int i;
                        String prefix = xmlStreamReader.getPrefix();
                        if (prefix != null && prefix.length() == 0) {
                            prefix = null;
                        }
                        String localName = xmlStreamReader.getLocalName();
                        Element element = new Element(prefix, localName);
                        int n = xmlStreamReader.getNamespaceCount();
                        for (i = 0; i < n; ++i) {
                            String namespacePrefix = xmlStreamReader.getNamespacePrefix(i);
                            String namespaceURI = xmlStreamReader.getNamespaceURI(i);
                            if (namespacePrefix == null) {
                                element.setDefaultNamespaceURI(namespaceURI);
                                continue;
                            }
                            element.getNamespaces().put(namespacePrefix, namespaceURI);
                        }
                        n = xmlStreamReader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            String attributePrefix = xmlStreamReader.getAttributePrefix(i);
                            if (attributePrefix != null && attributePrefix.length() == 0) {
                                attributePrefix = null;
                            }
                            String attributeLocalName = xmlStreamReader.getAttributeLocalName(i);
                            String attributeValue = xmlStreamReader.getAttributeValue(i);
                            element.getAttributes().add(new Element.Attribute(attributePrefix, attributeLocalName, attributeValue));
                        }
                        if (current == null) {
                            document = element;
                        } else {
                            ((Element)current).add(element);
                        }
                        if (this.xmlSerializerListeners != null) {
                            this.xmlSerializerListeners.beginElement(this, element);
                        }
                        current = element;
                        break;
                    }
                    case 2: {
                        if (this.xmlSerializerListeners != null) {
                            this.xmlSerializerListeners.endElement(this);
                        }
                        if (current == null) break;
                        current = current.getParent();
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException exception) {
            throw new SerializationException(exception);
        }
        return document;
    }

    @Override
    public void writeObject(Element element, OutputStream outputStream) throws IOException, SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        this.writeObject(element, writer);
        ((Writer)writer).flush();
    }

    public void writeObject(Element element, Writer writer) throws SerializationException {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        if (element == null) {
            throw new IllegalArgumentException("element is null.");
        }
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xmlStreamWriter = output.createXMLStreamWriter(writer);
            xmlStreamWriter.writeStartDocument();
            this.writeElement(element, xmlStreamWriter);
            xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exception) {
            throw new SerializationException(exception);
        }
    }

    private void writeElement(Element element, XMLStreamWriter xmlStreamWriter) throws XMLStreamException, SerializationException {
        String namespacePrefix = element.getNamespacePrefix();
        String localName = element.getLocalName();
        if (namespacePrefix == null) {
            if (element.getLength() == 0) {
                xmlStreamWriter.writeEmptyElement(localName);
            } else {
                xmlStreamWriter.writeStartElement(localName);
            }
        } else {
            String namespaceURI = element.getNamespaceURI(namespacePrefix);
            if (element.getLength() == 0) {
                xmlStreamWriter.writeEmptyElement(namespacePrefix, localName, namespaceURI);
            } else {
                xmlStreamWriter.writeStartElement(namespacePrefix, localName, namespaceURI);
            }
        }
        String defaultNamespaceURI = element.getDefaultNamespaceURI();
        if (defaultNamespaceURI != null) {
            xmlStreamWriter.writeDefaultNamespace(defaultNamespaceURI);
        }
        Element.NamespaceDictionary namespaces = element.getNamespaces();
        for (String declaredNamespacePrefix : namespaces) {
            String declaredNamespaceURI = namespaces.get(declaredNamespacePrefix);
            xmlStreamWriter.writeNamespace(declaredNamespacePrefix, declaredNamespaceURI);
        }
        for (Element.Attribute attribute : element.getAttributes()) {
            String attributeNamespacePrefix = attribute.getNamespacePrefix();
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            if (attributeNamespacePrefix == null) {
                xmlStreamWriter.writeAttribute(attributeLocalName, attributeValue);
                continue;
            }
            String attributeNamespaceURI = element.getNamespaceURI(attributeNamespacePrefix);
            xmlStreamWriter.writeAttribute(attributeNamespacePrefix, attributeNamespaceURI, attributeLocalName, attributeValue);
        }
        for (Node node : element) {
            if (node instanceof Element) {
                this.writeElement((Element)node, xmlStreamWriter);
                continue;
            }
            if (node instanceof TextNode) {
                XMLSerializer.writeTextNode((TextNode)node, xmlStreamWriter);
                continue;
            }
            throw new SerializationException("Unsupported node type: " + node.getClass().getName());
        }
        if (element.getLength() > 0) {
            xmlStreamWriter.writeEndElement();
        }
    }

    private static void writeTextNode(TextNode textNode, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeCharacters(textNode.getText());
    }

    @Override
    public String getMIMEType(Element object) {
        return MIME_TYPE;
    }

    public ListenerList<XMLSerializerListener> getXMLSerializerListeners() {
        if (this.xmlSerializerListeners == null) {
            this.xmlSerializerListeners = new XMLSerializerListenerList();
        }
        return this.xmlSerializerListeners;
    }

    private static class XMLSerializerListenerList
    extends ListenerList<XMLSerializerListener>
    implements XMLSerializerListener {
        private XMLSerializerListenerList() {
        }

        @Override
        public void beginElement(XMLSerializer xmlSerializer, Element element) {
            for (XMLSerializerListener listener : this) {
                listener.beginElement(xmlSerializer, element);
            }
        }

        @Override
        public void endElement(XMLSerializer xmlSerializer) {
            for (XMLSerializerListener listener : this) {
                listener.endElement(xmlSerializer);
            }
        }

        @Override
        public void readTextNode(XMLSerializer xmlSerializer, TextNode textNode) {
            for (XMLSerializerListener listener : this) {
                listener.readTextNode(xmlSerializer, textNode);
            }
        }
    }
}

