/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -3677773163272115116L;
    private short majorRevision = 0;
    private short minorRevision = 0;
    private short maintenanceRevision = 0;
    private short updateRevision = 0;
    private String build = null;

    public Version(int majorRevision, int minorRevision, int maintenanceRevision, int updateRevision) {
        this(majorRevision, minorRevision, maintenanceRevision, updateRevision, null);
    }

    public Version(int majorRevision, int minorRevision, int maintenanceRevision, int updateRevision, String build) {
        if (majorRevision > Short.MAX_VALUE) {
            throw new IllegalArgumentException("majorRevision must be less than or equal 32767.");
        }
        if (minorRevision > Short.MAX_VALUE) {
            throw new IllegalArgumentException("minorRevision must be less than or equal 32767.");
        }
        if (maintenanceRevision > Short.MAX_VALUE) {
            throw new IllegalArgumentException("maintenanceRevision must be less than or equal 32767.");
        }
        if (updateRevision > Short.MAX_VALUE) {
            throw new IllegalArgumentException("updateRevision must be less than or equal 32767.");
        }
        this.majorRevision = (short)majorRevision;
        this.minorRevision = (short)minorRevision;
        this.maintenanceRevision = (short)maintenanceRevision;
        this.updateRevision = (short)updateRevision;
        this.build = build;
    }

    public short getMajorRevision() {
        return this.majorRevision;
    }

    public short getMinorRevision() {
        return this.minorRevision;
    }

    public short getMaintenanceRevision() {
        return this.maintenanceRevision;
    }

    public short getUpdateRevision() {
        return this.updateRevision;
    }

    public long getNumber() {
        long number = (long)(this.majorRevision & 0xFFFF) << 48 | (long)(this.minorRevision & 0xFFFF) << 32 | (long)(this.maintenanceRevision & 0xFFFF) << 16 | (long)(this.updateRevision & 0xFFFF) << 0;
        return number;
    }

    @Override
    public int compareTo(Version version) {
        return new Long(this.getNumber()).compareTo(version.getNumber());
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        return new Long(this.getNumber()).hashCode();
    }

    public String toString() {
        String string = this.majorRevision + "." + this.minorRevision + "." + this.maintenanceRevision + "_" + String.format("%02d", this.updateRevision);
        if (this.build != null) {
            string = string + "-" + this.build;
        }
        return string;
    }

    public static Version decode(String string) {
        String revision;
        Version version = null;
        short majorRevision = 0;
        short minorRevision = 0;
        int maintenanceRevision = 0;
        int updateRevision = 0;
        String build = null;
        int i = string.indexOf(" ");
        if (i == -1) {
            i = string.indexOf("-");
        }
        if (i == -1) {
            revision = string;
        } else {
            revision = string.substring(0, i);
            build = string.substring(i + 1);
        }
        String[] revisionNumbers = revision.split("\\.");
        if (revisionNumbers.length > 0) {
            majorRevision = Short.parseShort(revisionNumbers[0]);
            if (revisionNumbers.length > 1) {
                String[] maintenanceRevisionNumbers;
                minorRevision = Short.parseShort(revisionNumbers[1]);
                if (revisionNumbers.length > 2 && (maintenanceRevisionNumbers = revisionNumbers[2].split("_")).length > 0) {
                    maintenanceRevision = Short.parseShort(maintenanceRevisionNumbers[0]);
                    if (maintenanceRevisionNumbers.length > 1) {
                        updateRevision = Short.parseShort(maintenanceRevisionNumbers[1]);
                    }
                }
            }
            version = new Version(majorRevision, minorRevision, maintenanceRevision, updateRevision, build);
        }
        return version;
    }
}

