/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.ImmutableIterator;

public class MIMEType
implements Dictionary<String, String>,
Iterable<String> {
    private String baseType;
    private HashMap<String, String> parameters = new HashMap();

    public MIMEType(String baseType) {
        this.baseType = baseType;
    }

    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public String get(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.parameters.put(key, value);
    }

    @Override
    public String remove(String key) {
        return this.parameters.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    @Override
    public Iterator<String> iterator() {
        return new ImmutableIterator<String>(this.parameters.iterator());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.baseType);
        if (!this.parameters.isEmpty()) {
            for (String parameter : this.parameters) {
                stringBuilder.append("; " + parameter + "=" + this.parameters.get(parameter));
            }
        }
        return stringBuilder.toString();
    }

    public static MIMEType decode(String value) {
        MIMEType mimeType;
        if (value == null) {
            throw new IllegalArgumentException("value is null.");
        }
        int i = value.indexOf(";");
        if (i == -1) {
            mimeType = new MIMEType(value);
        } else {
            mimeType = new MIMEType(value.substring(0, i));
            int n = value.length();
            do {
                String parameterValue;
                int j;
                if ((j = value.indexOf("=", i)) == -1) {
                    throw new IllegalArgumentException("Parameter list is invalid.");
                }
                String parameterKey = value.substring(i + 1, j).trim();
                if (parameterKey.length() == 0) {
                    throw new IllegalArgumentException("Missing parameter name.");
                }
                i = value.indexOf(";", j);
                if (i == -1) {
                    i = n;
                }
                if ((parameterValue = value.substring(j + 1, i).trim()).length() == 0) {
                    throw new IllegalArgumentException("Missing parameter value.");
                }
                mimeType.put(parameterKey, parameterValue);
            } while (i < n);
        }
        return mimeType;
    }
}

