/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Time;

public final class CalendarDate
implements Comparable<CalendarDate>,
Serializable {
    private static final long serialVersionUID = 3974393986540543704L;
    public final int year;
    public final int month;
    public final int day;
    private static final int[] MONTH_LENGTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int GREGORIAN_CUTOVER_YEAR = 1582;
    private static final Pattern PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");

    public static int getMinimumSupportedYear() {
        return 1583;
    }

    public static int getMaximumSupportedYear() {
        return 9999;
    }

    public CalendarDate() {
        this(new GregorianCalendar());
    }

    public CalendarDate(GregorianCalendar calendar) {
        this(calendar.get(1), calendar.get(2), calendar.get(5) - 1);
    }

    public CalendarDate(int year, int month, int day) {
        boolean isLeapYear;
        if (year <= 1582 || year > 9999) {
            throw new IllegalArgumentException("Invalid year: " + year);
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        int daysInMonth = MONTH_LENGTHS[month];
        boolean bl = isLeapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
        if (isLeapYear && month == 1) {
            ++daysInMonth;
        }
        if (day < 0 || day >= daysInMonth) {
            throw new IllegalArgumentException("Invalid day: " + day);
        }
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public CalendarDate add(int days) {
        GregorianCalendar calendar = this.toCalendar();
        calendar.add(6, days);
        return new CalendarDate(calendar);
    }

    public int subtract(CalendarDate calendarDate) {
        GregorianCalendar c1 = this.toCalendar();
        GregorianCalendar c2 = calendarDate.toCalendar();
        long t1 = c1.getTimeInMillis();
        long t2 = c2.getTimeInMillis();
        return (int)((t1 - t2) / 86400000L);
    }

    public GregorianCalendar toCalendar() {
        return this.toCalendar(new Time(0, 0, 0));
    }

    public GregorianCalendar toCalendar(Time time) {
        GregorianCalendar calendar = new GregorianCalendar(this.year, this.month, this.day + 1, time.hour, time.minute, time.second);
        calendar.set(14, time.millisecond);
        return calendar;
    }

    @Override
    public int compareTo(CalendarDate calendarDate) {
        int result = this.year - calendarDate.year;
        if (result == 0 && (result = this.month - calendarDate.month) == 0) {
            result = this.day - calendarDate.day;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof CalendarDate && ((CalendarDate)o).year == this.year && ((CalendarDate)o).month == this.month && ((CalendarDate)o).day == this.day;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        format.setMinimumIntegerDigits(4);
        buf.append(format.format(this.year));
        buf.append("-");
        format.setMinimumIntegerDigits(2);
        buf.append(format.format(this.month + 1));
        buf.append("-");
        buf.append(format.format(this.day + 1));
        return buf.toString();
    }

    public static CalendarDate decode(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid date format: " + value);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2)) - 1;
        int day = Integer.parseInt(matcher.group(3)) - 1;
        return new CalendarDate(year, month, day);
    }

    public static final class Range {
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public final CalendarDate start;
        public final CalendarDate end;

        public Range(CalendarDate calendarDate) {
            this(calendarDate, calendarDate);
        }

        public Range(CalendarDate start, CalendarDate end) {
            this.start = start;
            this.end = end;
        }

        public Range(String start, String end) {
            this.start = CalendarDate.decode(start);
            this.end = CalendarDate.decode(end);
        }

        public Range(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            this.start = range.start;
            this.end = range.end;
        }

        public Range(Dictionary<String, ?> range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Object startRange = range.get(START_KEY);
            Object endRange = range.get(END_KEY);
            if (startRange == null) {
                throw new IllegalArgumentException("start is required.");
            }
            if (endRange == null) {
                throw new IllegalArgumentException("end is required.");
            }
            this.start = startRange instanceof String ? CalendarDate.decode((String)startRange) : (CalendarDate)startRange;
            this.end = endRange instanceof String ? CalendarDate.decode((String)endRange) : (CalendarDate)endRange;
        }

        public int getLength() {
            return Math.abs(this.start.subtract(this.end)) + 1;
        }

        public boolean contains(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range normalizedRange = range.normalize();
            boolean contains = this.start.compareTo(this.end) < 0 ? this.start.compareTo(normalizedRange.start) <= 0 && this.end.compareTo(normalizedRange.end) >= 0 : this.end.compareTo(normalizedRange.start) <= 0 && this.start.compareTo(normalizedRange.end) >= 0;
            return contains;
        }

        public boolean contains(CalendarDate calendarDate) {
            if (calendarDate == null) {
                throw new IllegalArgumentException("calendarDate is null.");
            }
            boolean contains = this.start.compareTo(this.end) < 0 ? this.start.compareTo(calendarDate) <= 0 && this.end.compareTo(calendarDate) >= 0 : this.end.compareTo(calendarDate) <= 0 && this.start.compareTo(calendarDate) >= 0;
            return contains;
        }

        public boolean intersects(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range normalizedRange = range.normalize();
            boolean intersects = this.start.compareTo(this.end) < 0 ? this.start.compareTo(normalizedRange.end) <= 0 && this.end.compareTo(normalizedRange.start) >= 0 : this.end.compareTo(normalizedRange.end) <= 0 && this.start.compareTo(normalizedRange.start) >= 0;
            return intersects;
        }

        public Range normalize() {
            CalendarDate earlier = this.start.compareTo(this.end) < 0 ? this.start : this.end;
            CalendarDate later = earlier == this.start ? this.end : this.start;
            return new Range(earlier, later);
        }

        public static Range decode(String value) {
            Range range;
            if (value == null) {
                throw new IllegalArgumentException();
            }
            if (value.startsWith("{")) {
                try {
                    range = new Range(JSONSerializer.parseMap(value));
                }
                catch (SerializationException exception) {
                    throw new IllegalArgumentException(exception);
                }
            } else {
                range = new Range(CalendarDate.decode(value));
            }
            return range;
        }
    }
}

