/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class FileSizeFormat
extends Format {
    private static final long serialVersionUID = 9126510513247641698L;
    public static final int KILOBYTE = 1024;
    public static final String[] ABBREVIATIONS = new String[]{"K", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final FileSizeFormat FILE_SIZE_FORMAT = new FileSizeFormat();

    private FileSizeFormat() {
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Number number = (Number)object;
        long length = number.longValue();
        if (length >= 0L) {
            double size = length;
            int i = -1;
            do {
                ++i;
            } while ((size /= 1024.0) > 1024.0);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (i == 0 && size > 1.0) {
                numberFormat.setMaximumFractionDigits(0);
            } else {
                numberFormat.setMaximumFractionDigits(1);
            }
            stringBuffer.append(numberFormat.format(size) + " " + ABBREVIATIONS[i] + "B");
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String arg0, ParsePosition arg1) {
        throw new UnsupportedOperationException();
    }

    public static FileSizeFormat getInstance() {
        return FILE_SIZE_FORMAT;
    }
}

