/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.text;

import java.text.CharacterIterator;

public final class CharSequenceCharacterIterator
implements CharacterIterator {
    private CharSequence charSequence;
    private int beginIndex;
    private int endIndex;
    private int index = -1;

    public CharSequenceCharacterIterator(CharSequence charSequence) {
        this(charSequence, 0);
    }

    public CharSequenceCharacterIterator(CharSequence charSequence, int beginIndex) {
        this(charSequence, beginIndex, -1);
    }

    public CharSequenceCharacterIterator(CharSequence charSequence, int beginIndex, int endIndex) {
        this(charSequence, beginIndex, endIndex, beginIndex);
    }

    public CharSequenceCharacterIterator(CharSequence charSequence, int beginIndex, int endIndex, int index) {
        if (charSequence == null) {
            throw new IllegalArgumentException("charSequence may not be null");
        }
        int endIndexUpdated = endIndex;
        if (endIndex == -1) {
            endIndexUpdated = charSequence.length();
        }
        if (beginIndex > endIndexUpdated) {
            throw new IllegalArgumentException("beginIndex > endIndex, " + beginIndex + ">" + endIndexUpdated);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex < 0, " + beginIndex);
        }
        if (endIndexUpdated > charSequence.length()) {
            throw new IndexOutOfBoundsException("endIndex > char sequence length, " + endIndexUpdated + ">" + charSequence.length());
        }
        if (index < beginIndex) {
            throw new IndexOutOfBoundsException("(index < beginIndex, " + index + "<" + beginIndex);
        }
        if (index > endIndexUpdated) {
            throw new IndexOutOfBoundsException("(index > endIndex, " + index + ">" + endIndexUpdated);
        }
        this.charSequence = charSequence;
        this.beginIndex = beginIndex;
        this.endIndex = endIndexUpdated;
        this.setIndex(index);
    }

    @Override
    public char first() {
        return this.setIndex(this.beginIndex);
    }

    @Override
    public char last() {
        return this.setIndex(this.charSequence.length() == 0 ? this.endIndex : this.endIndex - 1);
    }

    @Override
    public char next() {
        return this.setIndex(this.index < this.endIndex ? this.index + 1 : 65535);
    }

    @Override
    public char previous() {
        return this.setIndex(this.index > this.beginIndex ? this.index - 1 : 65535);
    }

    @Override
    public char current() {
        return this.index < this.endIndex ? this.charSequence.charAt(this.index) : (char)'\uffff';
    }

    @Override
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char setIndex(int index) {
        if (index < this.beginIndex || index > this.endIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.index = index;
        return this.current();
    }

    @Override
    public Object clone() {
        return new CharSequenceCharacterIterator(this.charSequence, this.beginIndex, this.endIndex, this.index);
    }
}

