/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class StringSerializer
implements Serializer<String> {
    private final Charset charset;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String TEXT_EXTENSION = "txt";
    public static final String MIME_TYPE = "text/plain";
    public static final int BUFFER_SIZE = 2048;

    public StringSerializer() {
        this(Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public StringSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        String result = null;
        try {
            int read;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((read = bufferedInputStream.read(buffer)) != -1) {
                byteOutputStream.write(buffer, 0, read);
            }
            byteOutputStream.flush();
            result = new String(byteOutputStream.toByteArray(), this.charset);
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return result;
    }

    @Override
    public void writeObject(String text, OutputStream outputStream) throws IOException, SerializationException {
        if (text == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            bufferedOutputStream.write(text.getBytes(this.charset));
            bufferedOutputStream.flush();
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
    }

    @Override
    public String getMIMEType(String object) {
        return MIME_TYPE;
    }
}

