/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.collections.ArrayAdapter;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.io.EchoReader;
import org.apache.pivot.io.EchoWriter;
import org.apache.pivot.serialization.CSVSerializerListener;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;

public class CSVSerializer
implements Serializer<List<?>> {
    private Charset charset;
    private Type itemType;
    private ArrayList<String> keys = new ArrayList();
    private boolean writeKeys = false;
    private boolean verbose = false;
    private int c = -1;
    private CSVSerializerListenerList csvSerializerListeners = null;
    public static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    public static final Type DEFAULT_ITEM_TYPE = HashMap.class;
    public static final String CSV_EXTENSION = "csv";
    public static final String MIME_TYPE = "text/csv";
    public static final int BUFFER_SIZE = 2048;

    public CSVSerializer() {
        this(Charset.forName(DEFAULT_CHARSET_NAME), DEFAULT_ITEM_TYPE);
    }

    public CSVSerializer(Charset charset) {
        this(charset, DEFAULT_ITEM_TYPE);
    }

    public CSVSerializer(Type itemType) {
        this(Charset.forName(DEFAULT_CHARSET_NAME), itemType);
    }

    public CSVSerializer(Charset charset, Type itemType) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        if (itemType == null) {
            throw new IllegalArgumentException("itemType is null.");
        }
        this.charset = charset;
        this.itemType = itemType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Type getItemType() {
        return this.itemType;
    }

    public Sequence<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Sequence<String> keys) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        this.keys = new ArrayList<String>(keys);
    }

    public void setKeys(String ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        this.setKeys(new ArrayAdapter<String>(keys));
    }

    public boolean getWriteKeys() {
        return this.writeKeys;
    }

    public void setWriteKeys(boolean writeKeys) {
        this.writeKeys = writeKeys;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<?> readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        Reader reader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        if (this.verbose) {
            reader = new EchoReader(reader);
        }
        return this.readObject(reader);
    }

    public List<?> readObject(Reader reader) throws IOException, SerializationException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        if (this.keys.getLength() == 0) {
            String line = lineNumberReader.readLine();
            if (line == null) {
                throw new SerializationException("Could not read keys from input.");
            }
            String[] keysLocal = line.split(",");
            this.keys = new ArrayList(keysLocal.length);
            for (int i = 0; i < keysLocal.length; ++i) {
                String key = keysLocal[i];
                this.keys.add(key.trim());
            }
        }
        ArrayList<Object> items = new ArrayList<Object>();
        if (this.csvSerializerListeners != null) {
            this.csvSerializerListeners.beginList(this, items);
        }
        this.c = lineNumberReader.read();
        if (this.c == 65279) {
            this.c = lineNumberReader.read();
        }
        try {
            while (this.c != -1) {
                Object item = this.readItem(lineNumberReader);
                while (item != null) {
                    items.add(item);
                    while (this.c != -1 && (this.c == 13 || this.c == 10)) {
                        this.c = lineNumberReader.read();
                    }
                    item = this.readItem(lineNumberReader);
                }
            }
        }
        catch (SerializationException exception) {
            System.err.println("An error occurred while processing input at line number " + (lineNumberReader.getLineNumber() + 1));
            throw exception;
        }
        if (this.csvSerializerListeners != null) {
            this.csvSerializerListeners.endList(this);
        }
        return items;
    }

    private Object readItem(Reader reader) throws IOException, SerializationException {
        Object item = null;
        if (this.c != -1) {
            Dictionary itemDictionary;
            try {
                if (this.itemType instanceof ParameterizedType) {
                    ParameterizedType parameterizedItemType = (ParameterizedType)this.itemType;
                    Class rawItemType = (Class)parameterizedItemType.getRawType();
                    item = rawItemType.newInstance();
                } else {
                    Class classItemType = (Class)this.itemType;
                    item = classItemType.newInstance();
                }
                itemDictionary = item instanceof Dictionary ? (Dictionary)item : new BeanAdapter(item);
            }
            catch (IllegalAccessException exception) {
                throw new SerializationException(exception);
            }
            catch (InstantiationException exception) {
                throw new SerializationException(exception);
            }
            int n = this.keys.getLength();
            for (int i = 0; i < n; ++i) {
                String key = this.keys.get(i);
                String value = this.readValue(reader);
                if (value == null) {
                    throw new SerializationException("Error reading value for " + key + " from input stream.");
                }
                if (this.c == 13 || this.c == 10) {
                    if (i < n - 1) {
                        throw new SerializationException("Line data is incomplete.");
                    }
                    this.c = reader.read();
                    if (this.c == 10) {
                        this.c = reader.read();
                    }
                }
                itemDictionary.put(key, value);
            }
            if (this.csvSerializerListeners != null) {
                this.csvSerializerListeners.readItem(this, item);
            }
        }
        return item;
    }

    private String readValue(Reader reader) throws IOException, SerializationException {
        String value = null;
        if (this.c != -1 && this.c != 13 && this.c != 10) {
            boolean quoted;
            StringBuilder valueBuilder = new StringBuilder();
            boolean bl = quoted = this.c == 34;
            if (quoted) {
                this.c = reader.read();
            }
            while (this.c != -1 && (quoted || this.c != 44 && this.c != 13 && this.c != 10)) {
                if (this.c == 34) {
                    if (!quoted) {
                        throw new SerializationException("Dangling quote.");
                    }
                    this.c = reader.read();
                    if (this.c != 34 && this.c != 44 && this.c != 13 && this.c != 10 && this.c != -1) {
                        throw new SerializationException("Prematurely terminated quote.");
                    }
                    quoted &= this.c == 34;
                }
                if (this.c == -1 || !quoted && (this.c == 44 || this.c == 13 || this.c == 10)) continue;
                valueBuilder.append((char)this.c);
                this.c = reader.read();
            }
            if (quoted) {
                throw new SerializationException("Unterminated string.");
            }
            value = valueBuilder.toString();
            if (this.c == 44) {
                this.c = reader.read();
            }
        }
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    @Override
    public void writeObject(List<?> items, OutputStream outputStream) throws IOException, SerializationException {
        if (items == null) {
            throw new IllegalArgumentException("items is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        Writer writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        if (this.verbose) {
            writer = new EchoWriter(writer);
        }
        this.writeObject(items, writer);
    }

    public void writeObject(List<?> items, Writer writer) throws IOException {
        if (items == null) {
            throw new IllegalArgumentException("items is null.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        if (this.writeKeys) {
            int n = this.keys.getLength();
            for (int i = 0; i < n; ++i) {
                String key = this.keys.get(i);
                if (i > 0) {
                    writer.append(",");
                }
                writer.append(key);
            }
        }
        for (Object item : items) {
            Dictionary itemDictionary = item instanceof Dictionary ? (Dictionary)item : new BeanAdapter(item);
            int n = this.keys.getLength();
            for (int i = 0; i < n; ++i) {
                Object value;
                String key = this.keys.get(i);
                if (i > 0) {
                    writer.append(",");
                }
                if ((value = itemDictionary.get(key)) == null) continue;
                String string = value.toString();
                if (string.indexOf(44) >= 0 || string.indexOf(34) >= 0 || string.indexOf(13) >= 0 || string.indexOf(10) >= 0) {
                    writer.append('\"');
                    if (string.indexOf(34) == -1) {
                        writer.append(string);
                    } else {
                        writer.append(string.replace("\"", "\"\""));
                    }
                    writer.append('\"');
                    continue;
                }
                writer.append(string);
            }
            writer.append("\r\n");
        }
        writer.flush();
    }

    @Override
    public String getMIMEType(List<?> objects) {
        return "text/csv; charset=" + this.charset.name();
    }

    public ListenerList<CSVSerializerListener> getCSVSerializerListeners() {
        if (this.csvSerializerListeners == null) {
            this.csvSerializerListeners = new CSVSerializerListenerList();
        }
        return this.csvSerializerListeners;
    }

    private static class CSVSerializerListenerList
    extends ListenerList<CSVSerializerListener>
    implements CSVSerializerListener {
        private CSVSerializerListenerList() {
        }

        @Override
        public void beginList(CSVSerializer csvSerializer, List<?> list) {
            for (CSVSerializerListener listener : this) {
                listener.beginList(csvSerializer, list);
            }
        }

        @Override
        public void endList(CSVSerializer csvSerializer) {
            for (CSVSerializerListener listener : this) {
                listener.endList(csvSerializer);
            }
        }

        @Override
        public void readItem(CSVSerializer csvSerializer, Object item) {
            for (CSVSerializerListener listener : this) {
                listener.readItem(csvSerializer, item);
            }
        }
    }
}

