/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.json;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.adapter.MapAdapter;
import org.apache.pivot.io.EchoReader;
import org.apache.pivot.io.EchoWriter;
import org.apache.pivot.json.JSONSerializerListener;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;

public class JSONSerializer
implements Serializer<Object> {
    private Charset charset;
    private Type type;
    private boolean alwaysDelimitMapKeys = false;
    private boolean verbose = false;
    private int c = -1;
    private JSONSerializerListenerList jsonSerializerListeners = null;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Type DEFAULT_TYPE = Object.class;
    public static final String JSON_EXTENSION = "json";
    public static final String MIME_TYPE = "application/json";
    public static final int BUFFER_SIZE = 2048;

    public JSONSerializer() {
        this(Charset.forName(DEFAULT_CHARSET_NAME), DEFAULT_TYPE);
    }

    public JSONSerializer(Charset charset) {
        this(charset, DEFAULT_TYPE);
    }

    public JSONSerializer(Type type) {
        this(Charset.forName(DEFAULT_CHARSET_NAME), type);
    }

    public JSONSerializer(Charset charset, Type type) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null.");
        }
        this.charset = charset;
        this.type = type;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getAlwaysDelimitMapKeys() {
        return this.alwaysDelimitMapKeys;
    }

    public void setAlwaysDelimitMapKeys(boolean alwaysDelimitMapKeys) {
        this.alwaysDelimitMapKeys = alwaysDelimitMapKeys;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Object readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        Reader reader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        if (this.verbose) {
            reader = new EchoReader(reader);
        }
        return this.readObject(reader);
    }

    public Object readObject(Reader reader) throws IOException, SerializationException {
        Object object;
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        this.c = lineNumberReader.read();
        if (this.c == 65279) {
            this.c = lineNumberReader.read();
        }
        try {
            object = this.readValue(lineNumberReader, this.type);
        }
        catch (SerializationException exception) {
            System.err.println("An error occurred while processing input at line number " + (lineNumberReader.getLineNumber() + 1));
            throw exception;
        }
        return object;
    }

    private Object readValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        Object object = null;
        this.skipWhitespaceAndComments(reader);
        if (this.c == -1) {
            throw new SerializationException("Unexpected end of input stream.");
        }
        if (this.c == 110) {
            object = this.readNullValue(reader);
        } else if (this.c == 34 || this.c == 39) {
            object = this.readStringValue(reader, typeArgument);
        } else if (this.c == 43 || this.c == 45 || Character.isDigit(this.c)) {
            object = this.readNumberValue(reader, typeArgument);
        } else if (this.c == 116 || this.c == 102) {
            object = this.readBooleanValue(reader, typeArgument);
        } else if (this.c == 91) {
            object = this.readListValue(reader, typeArgument);
        } else if (this.c == 123) {
            object = this.readMapValue(reader, typeArgument);
        } else {
            throw new SerializationException("Unexpected character in input stream.");
        }
        return object;
    }

    private void skipWhitespaceAndComments(Reader reader) throws IOException, SerializationException {
        while (this.c != -1 && (Character.isWhitespace(this.c) || this.c == 47)) {
            boolean comment = this.c == 47;
            this.c = reader.read();
            if (!comment) continue;
            if (this.c == 47) {
                while (this.c != -1 && this.c != 10 && this.c != 13) {
                    this.c = reader.read();
                }
                continue;
            }
            if (this.c == 42) {
                boolean closed = false;
                while (this.c != -1 && !closed) {
                    this.c = reader.read();
                    if (this.c != 42) continue;
                    this.c = reader.read();
                    closed = this.c == 47;
                }
                if (!closed) {
                    throw new SerializationException("Unexpected end of input stream.");
                }
                if (this.c == -1) continue;
                this.c = reader.read();
                continue;
            }
            throw new SerializationException("Unexpected character in input stream.");
        }
    }

    private Object readNullValue(Reader reader) throws IOException, SerializationException {
        int i;
        String nullString = "null";
        int n = nullString.length();
        for (i = 0; this.c != -1 && i < n; ++i) {
            if (nullString.charAt(i) != this.c) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
        }
        if (i < n) {
            throw new SerializationException("Incomplete null value in input stream.");
        }
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.readNull(this);
        }
        return null;
    }

    private String readString(Reader reader) throws IOException, SerializationException {
        StringBuilder stringBuilder = new StringBuilder();
        int t = this.c;
        this.c = reader.read();
        while (this.c != -1 && this.c != t) {
            if (!Character.isISOControl(this.c)) {
                if (this.c == 92) {
                    this.c = reader.read();
                    if (this.c == 98) {
                        this.c = 8;
                    } else if (this.c == 102) {
                        this.c = 12;
                    } else if (this.c == 110) {
                        this.c = 10;
                    } else if (this.c == 114) {
                        this.c = 13;
                    } else if (this.c == 116) {
                        this.c = 9;
                    } else if (this.c == 117) {
                        StringBuilder unicodeBuilder = new StringBuilder();
                        while (unicodeBuilder.length() < 4) {
                            this.c = reader.read();
                            unicodeBuilder.append((char)this.c);
                        }
                        String unicode = unicodeBuilder.toString();
                        this.c = (char)Integer.parseInt(unicode, 16);
                    } else if (this.c != 92 && this.c != 47 && this.c != 34 && this.c != 39 && this.c != t) {
                        throw new SerializationException("Unsupported escape sequence in input stream.");
                    }
                }
                stringBuilder.append((char)this.c);
            }
            this.c = reader.read();
        }
        if (this.c != t) {
            throw new SerializationException("Unterminated string in input stream.");
        }
        this.c = reader.read();
        return stringBuilder.toString();
    }

    private Object readStringValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        if (!(typeArgument instanceof Class)) {
            throw new SerializationException("Cannot convert string to " + typeArgument + ".");
        }
        String string = this.readString(reader);
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.readString(this, string);
        }
        return BeanAdapter.coerce(string, (Class)typeArgument);
    }

    private Object readNumberValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        long value;
        if (!(typeArgument instanceof Class)) {
            throw new SerializationException("Cannot convert number to " + typeArgument + ".");
        }
        Number number = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean negative = false;
        boolean integer = true;
        if (this.c == 43 || this.c == 45) {
            negative = this.c == 45;
            this.c = reader.read();
        }
        while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69 || this.c == 45)) {
            stringBuilder.append((char)this.c);
            integer &= this.c != 46;
            this.c = reader.read();
        }
        number = integer ? (Number)((value = Long.parseLong(stringBuilder.toString()) * (long)(negative ? -1 : 1)) > Integer.MAX_VALUE || value < Integer.MIN_VALUE ? (Number)value : (Number)((int)value)) : (Number)(Double.parseDouble(stringBuilder.toString()) * (negative ? -1.0 : 1.0));
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.readNumber(this, number);
        }
        return BeanAdapter.coerce(number, (Class)typeArgument);
    }

    private Object readBooleanValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        int i;
        if (!(typeArgument instanceof Class)) {
            throw new SerializationException("Cannot convert boolean to " + typeArgument + ".");
        }
        String text = this.c == 116 ? "true" : "false";
        int n = text.length();
        for (i = 0; this.c != -1 && i < n; ++i) {
            if (text.charAt(i) != this.c) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
        }
        if (i < n) {
            throw new SerializationException("Incomplete boolean value in input stream.");
        }
        Boolean value = Boolean.parseBoolean(text);
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.readBoolean(this, value);
        }
        return BeanAdapter.coerce(value, (Class)typeArgument);
    }

    private Object readListValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        Sequence<Object> sequence = null;
        Object itemType = null;
        if (typeArgument == Object.class) {
            sequence = new ArrayList();
            itemType = Object.class;
        } else {
            Class sequenceType;
            Type parentType = typeArgument;
            while (parentType != null) {
                if (parentType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)parentType;
                    Class rawType = (Class)parameterizedType.getRawType();
                    if (!Sequence.class.isAssignableFrom(rawType)) break;
                    itemType = parameterizedType.getActualTypeArguments()[0];
                    break;
                }
                Class classType = (Class)parentType;
                Type[] genericInterfaces = classType.getGenericInterfaces();
                for (int i = 0; i < genericInterfaces.length; ++i) {
                    ParameterizedType parameterizedType;
                    Class interfaceType;
                    Type genericInterface = genericInterfaces[i];
                    if (!(genericInterface instanceof ParameterizedType) || !Sequence.class.isAssignableFrom(interfaceType = (Class)(parameterizedType = (ParameterizedType)genericInterface).getRawType())) continue;
                    itemType = parameterizedType.getActualTypeArguments()[0];
                    if (!(itemType instanceof TypeVariable)) break;
                    itemType = Object.class;
                    break;
                }
                if (itemType != null) break;
                parentType = classType.getGenericSuperclass();
            }
            if (itemType == null) {
                throw new SerializationException("Could not determine sequence item type.");
            }
            if (typeArgument instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeArgument;
                sequenceType = (Class)parameterizedType.getRawType();
            } else {
                sequenceType = (Class)typeArgument;
            }
            try {
                sequence = (Sequence)sequenceType.newInstance();
            }
            catch (InstantiationException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.beginSequence(this, sequence);
        }
        this.c = reader.read();
        this.skipWhitespaceAndComments(reader);
        while (this.c != -1 && this.c != 93) {
            sequence.add(this.readValue(reader, (Type)itemType));
            this.skipWhitespaceAndComments(reader);
            if (this.c == 44) {
                this.c = reader.read();
                this.skipWhitespaceAndComments(reader);
                continue;
            }
            if (this.c == -1) {
                throw new SerializationException("Unexpected end of input stream.");
            }
            if (this.c == 93) continue;
            throw new SerializationException("Unexpected character in input stream.");
        }
        this.c = reader.read();
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.endSequence(this);
        }
        return sequence;
    }

    private Object readMapValue(Reader reader, Type typeArgument) throws IOException, SerializationException {
        Dictionary<String, Object> dictionary = null;
        Object valueType = null;
        if (typeArgument == Object.class) {
            dictionary = new HashMap();
            valueType = Object.class;
        } else {
            Class dictionaryType;
            Type parentType = typeArgument;
            while (parentType != null) {
                if (parentType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)parentType;
                    Class rawType = (Class)parameterizedType.getRawType();
                    if (!Dictionary.class.isAssignableFrom(rawType)) break;
                    valueType = parameterizedType.getActualTypeArguments()[1];
                    break;
                }
                Class classType = (Class)parentType;
                Type[] genericInterfaces = classType.getGenericInterfaces();
                for (int i = 0; i < genericInterfaces.length; ++i) {
                    ParameterizedType parameterizedType;
                    Class interfaceType;
                    Type genericInterface = genericInterfaces[i];
                    if (!(genericInterface instanceof ParameterizedType) || !Dictionary.class.isAssignableFrom(interfaceType = (Class)(parameterizedType = (ParameterizedType)genericInterface).getRawType())) continue;
                    valueType = parameterizedType.getActualTypeArguments()[1];
                    if (!(valueType instanceof TypeVariable)) break;
                    valueType = Object.class;
                    break;
                }
                if (valueType != null) break;
                parentType = classType.getGenericSuperclass();
            }
            if (valueType == null) {
                Class beanType = (Class)typeArgument;
                try {
                    dictionary = new BeanAdapter(beanType.newInstance());
                }
                catch (InstantiationException exception) {
                    throw new RuntimeException(exception);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (typeArgument instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeArgument;
                dictionaryType = (Class)parameterizedType.getRawType();
            } else {
                dictionaryType = (Class)typeArgument;
            }
            try {
                dictionary = (Dictionary)dictionaryType.newInstance();
            }
            catch (InstantiationException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.beginDictionary(this, dictionary);
        }
        this.c = reader.read();
        this.skipWhitespaceAndComments(reader);
        while (this.c != -1 && this.c != 125) {
            String key = null;
            if (this.c == 34 || this.c == 39) {
                key = this.readString(reader);
            } else {
                StringBuilder keyBuilder = new StringBuilder();
                if (!Character.isJavaIdentifierStart(this.c)) {
                    throw new SerializationException("Illegal identifier start character.");
                }
                while (this.c != -1 && this.c != 58 && !Character.isWhitespace(this.c)) {
                    if (!Character.isJavaIdentifierPart(this.c)) {
                        throw new SerializationException("Illegal identifier character.");
                    }
                    keyBuilder.append((char)this.c);
                    this.c = reader.read();
                }
                if (this.c == -1) {
                    throw new SerializationException("Unexpected end of input stream.");
                }
                key = keyBuilder.toString();
            }
            if (key == null || key.length() == 0) {
                throw new SerializationException("\"" + key + "\" is not a valid key.");
            }
            if (this.jsonSerializerListeners != null) {
                this.jsonSerializerListeners.readKey(this, key);
            }
            this.skipWhitespaceAndComments(reader);
            if (this.c != 58) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
            if (valueType == null) {
                Type genericValueType = ((BeanAdapter)dictionary).getGenericType(key);
                if (genericValueType != null) {
                    dictionary.put(key, this.readValue(reader, genericValueType));
                } else {
                    this.readValue(reader, (Type)((Object)Object.class));
                }
            } else {
                dictionary.put(key, this.readValue(reader, (Type)valueType));
            }
            this.skipWhitespaceAndComments(reader);
            if (this.c == 44) {
                this.c = reader.read();
                this.skipWhitespaceAndComments(reader);
                continue;
            }
            if (this.c == -1) {
                throw new SerializationException("Unexpected end of input stream.");
            }
            if (this.c == 125) continue;
            throw new SerializationException("Unexpected character in input stream.");
        }
        this.c = reader.read();
        if (this.jsonSerializerListeners != null) {
            this.jsonSerializerListeners.endDictionary(this);
        }
        return dictionary instanceof BeanAdapter ? ((BeanAdapter)dictionary).getBean() : dictionary;
    }

    @Override
    public void writeObject(Object object, OutputStream outputStream) throws IOException, SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        Writer writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        if (this.verbose) {
            writer = new EchoWriter(writer);
        }
        this.writeObject(object, writer);
    }

    public void writeObject(Object object, Writer writer) throws IOException, SerializationException {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        if (object == null) {
            writer.append("null");
        } else if (object instanceof String) {
            String string = (String)object;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            block8: for (int i = 0; i < n; ++i) {
                char ci = string.charAt(i);
                switch (ci) {
                    case '\t': {
                        stringBuilder.append("\\t");
                        continue block8;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block8;
                    }
                    case '\f': {
                        stringBuilder.append("\\f");
                        continue block8;
                    }
                    case '\b': {
                        stringBuilder.append("\\b");
                        continue block8;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuilder.append("\\" + ci);
                        continue block8;
                    }
                    default: {
                        if (this.charset.name().startsWith("UTF") && !Character.isISOControl(ci) || ci > '\u001f' && ci != '\u007f' && ci <= '\u00ff') {
                            stringBuilder.append(ci);
                            continue block8;
                        }
                        stringBuilder.append("\\u");
                        stringBuilder.append(String.format("%04x", (short)ci));
                    }
                }
            }
            writer.append("\"" + stringBuilder.toString() + "\"");
        } else if (object instanceof Number) {
            Double d;
            Float f;
            Number number = (Number)object;
            if (number instanceof Float ? (f = (Float)number).isNaN() || f.isInfinite() : number instanceof Double && ((d = (Double)number).isNaN() || d.isInfinite())) {
                throw new SerializationException(number + " is not a valid value.");
            }
            writer.append(number.toString());
        } else if (object instanceof Boolean) {
            writer.append(object.toString());
        } else if (object instanceof List) {
            List list = (List)object;
            writer.append("[");
            int i = 0;
            for (Object item : list) {
                if (i > 0) {
                    writer.append(", ");
                }
                this.writeObject(item, writer);
                ++i;
            }
            writer.append("]");
        } else {
            org.apache.pivot.collections.Map map = object instanceof org.apache.pivot.collections.Map ? (MapAdapter)object : (object instanceof Map ? new MapAdapter((Map)object) : new BeanAdapter(object, true));
            writer.append("{");
            int i = 0;
            for (String key : map) {
                Object value = map.get(key);
                boolean identifier = true;
                StringBuilder keyStringBuilder = new StringBuilder();
                int n = key.length();
                for (int j = 0; j < n; ++j) {
                    char cj = key.charAt(j);
                    identifier &= Character.isJavaIdentifierPart(cj);
                    if (cj == '\"') {
                        keyStringBuilder.append('\\');
                    }
                    keyStringBuilder.append(cj);
                }
                key = keyStringBuilder.toString();
                if (i > 0) {
                    writer.append(", ");
                }
                if (!identifier || this.alwaysDelimitMapKeys) {
                    writer.append('\"');
                }
                writer.append(key);
                if (!identifier || this.alwaysDelimitMapKeys) {
                    writer.append('\"');
                }
                writer.append(": ");
                this.writeObject(value, writer);
                ++i;
            }
            writer.append("}");
        }
        writer.flush();
    }

    @Override
    public String getMIMEType(Object object) {
        return "application/json; charset=" + this.charset.name();
    }

    public static Object parse(String json) throws SerializationException {
        Object object;
        JSONSerializer jsonSerializer = new JSONSerializer();
        try {
            object = jsonSerializer.readObject(new StringReader(json));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return object;
    }

    public static String parseString(String json) throws SerializationException {
        return (String)JSONSerializer.parse(json);
    }

    public static Number parseNumber(String json) throws SerializationException {
        return (Number)JSONSerializer.parse(json);
    }

    public static Short parseShort(String json) throws SerializationException {
        return (Short)JSONSerializer.parse(json);
    }

    public static Integer parseInteger(String json) throws SerializationException {
        return (Integer)JSONSerializer.parse(json);
    }

    public static Long parseLong(String json) throws SerializationException {
        return (Long)JSONSerializer.parse(json);
    }

    public static Float parseFloat(String json) throws SerializationException {
        return (Float)JSONSerializer.parse(json);
    }

    public static Double parseDouble(String json) throws SerializationException {
        return (Double)JSONSerializer.parse(json);
    }

    public static Boolean parseBoolean(String json) throws SerializationException {
        return (Boolean)JSONSerializer.parse(json);
    }

    public static List<?> parseList(String json) throws SerializationException {
        return (List)JSONSerializer.parse(json);
    }

    public static org.apache.pivot.collections.Map<String, ?> parseMap(String json) throws SerializationException {
        return (org.apache.pivot.collections.Map)JSONSerializer.parse(json);
    }

    public static String toString(Object value) throws SerializationException {
        return JSONSerializer.toString(value, false);
    }

    public static String toString(Object value, boolean alwaysDelimitMapKeys) throws SerializationException {
        JSONSerializer jsonSerializer = new JSONSerializer();
        jsonSerializer.setAlwaysDelimitMapKeys(alwaysDelimitMapKeys);
        StringWriter writer = new StringWriter();
        try {
            jsonSerializer.writeObject(value, writer);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public ListenerList<JSONSerializerListener> getJSONSerializerListeners() {
        if (this.jsonSerializerListeners == null) {
            this.jsonSerializerListeners = new JSONSerializerListenerList();
        }
        return this.jsonSerializerListeners;
    }

    private static class JSONSerializerListenerList
    extends ListenerList<JSONSerializerListener>
    implements JSONSerializerListener {
        private JSONSerializerListenerList() {
        }

        @Override
        public void beginDictionary(JSONSerializer jsonSerializer, Dictionary<String, ?> value) {
            for (JSONSerializerListener listener : this) {
                listener.beginDictionary(jsonSerializer, value);
            }
        }

        @Override
        public void endDictionary(JSONSerializer jsonSerializer) {
            for (JSONSerializerListener listener : this) {
                listener.endDictionary(jsonSerializer);
            }
        }

        @Override
        public void readKey(JSONSerializer jsonSerializer, String key) {
            for (JSONSerializerListener listener : this) {
                listener.readKey(jsonSerializer, key);
            }
        }

        @Override
        public void beginSequence(JSONSerializer jsonSerializer, Sequence<?> value) {
            for (JSONSerializerListener listener : this) {
                listener.beginSequence(jsonSerializer, value);
            }
        }

        @Override
        public void endSequence(JSONSerializer jsonSerializer) {
            for (JSONSerializerListener listener : this) {
                listener.endSequence(jsonSerializer);
            }
        }

        @Override
        public void readString(JSONSerializer jsonSerializer, String value) {
            for (JSONSerializerListener listener : this) {
                listener.readString(jsonSerializer, value);
            }
        }

        @Override
        public void readNumber(JSONSerializer jsonSerializer, Number value) {
            for (JSONSerializerListener listener : this) {
                listener.readNumber(jsonSerializer, value);
            }
        }

        @Override
        public void readBoolean(JSONSerializer jsonSerializer, Boolean value) {
            for (JSONSerializerListener listener : this) {
                listener.readBoolean(jsonSerializer, value);
            }
        }

        @Override
        public void readNull(JSONSerializer jsonSerializer) {
            for (JSONSerializerListener listener : this) {
                listener.readNull(jsonSerializer);
            }
        }
    }
}

