/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.pivot.util.concurrent.AbortException;
import org.apache.pivot.util.concurrent.Task;

public abstract class IOTask<V>
extends Task<V> {
    protected volatile long bytesSent = 0L;
    protected volatile long bytesReceived = 0L;

    public IOTask() {
    }

    public IOTask(ExecutorService executorService) {
        super(executorService);
    }

    protected class MonitoredOutputStream
    extends OutputStream {
        private OutputStream outputStream;

        public MonitoredOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        @Override
        public void flush() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(b);
            IOTask.this.bytesSent += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(b, off, len);
            IOTask.this.bytesSent += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(b);
            ++IOTask.this.bytesSent;
        }
    }

    protected class MonitoredInputStream
    extends InputStream {
        private InputStream inputStream;
        long mark = 0L;

        public MonitoredInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int result = this.inputStream.read();
            if (result != -1) {
                ++IOTask.this.bytesReceived;
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int count = this.inputStream.read(b);
            if (count != -1) {
                IOTask.this.bytesReceived += (long)count;
            }
            return count;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int count = this.inputStream.read(b, off, len);
            if (count != -1) {
                IOTask.this.bytesReceived += (long)count;
            }
            return count;
        }

        @Override
        public long skip(long n) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            long count = this.inputStream.skip(n);
            IOTask.this.bytesReceived += count;
            return count;
        }

        @Override
        public int available() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public synchronized void mark(int readLimit) {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.inputStream.mark(readLimit);
            this.mark = IOTask.this.bytesReceived;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.inputStream.reset();
            IOTask.this.bytesReceived = this.mark;
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }
}

