/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedQueue<T>
implements Queue<T> {
    private Queue<T> queue;
    private SynchronizedQueueListenerList<T> queueListeners = new SynchronizedQueueListenerList();

    public SynchronizedQueue(Queue<T> queue) {
        if (queue == null) {
            throw new IllegalArgumentException("queue cannot be null.");
        }
        this.queue = queue;
    }

    @Override
    public synchronized void enqueue(T item) {
        this.queue.enqueue(item);
        this.queueListeners.itemEnqueued(this, item);
        this.notify();
    }

    @Override
    public synchronized T dequeue() {
        Object item = null;
        try {
            while (this.isEmpty()) {
                this.wait();
            }
            item = this.queue.dequeue();
            this.queueListeners.itemDequeued(this, item);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return item;
    }

    @Override
    public synchronized T peek() {
        return this.queue.peek();
    }

    @Override
    public synchronized void clear() {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
            this.queueListeners.queueCleared(this);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int getLength() {
        return this.queue.getLength();
    }

    @Override
    public synchronized Comparator<T> getComparator() {
        return this.queue.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.queue.setComparator(comparator);
        this.queueListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.queue.iterator());
    }

    @Override
    public ListenerList<QueueListener<T>> getQueueListeners() {
        return this.queueListeners;
    }

    private static class SynchronizedQueueListenerList<T>
    extends Queue.QueueListenerList<T> {
        private SynchronizedQueueListenerList() {
        }

        @Override
        public synchronized void add(QueueListener<T> listener) {
            super.add(listener);
        }

        @Override
        public synchronized void remove(QueueListener<T> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void itemEnqueued(Queue<T> queue, T item) {
            super.itemEnqueued(queue, item);
        }

        @Override
        public synchronized void itemDequeued(Queue<T> queue, T item) {
            super.itemDequeued(queue, item);
        }
    }
}

