/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedList<T>
implements List<T> {
    private List<T> list;
    private SynchronizedListListenerList<T> listListeners = new SynchronizedListListenerList();

    public SynchronizedList(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null.");
        }
        this.list = list;
    }

    @Override
    public synchronized int add(T item) {
        int index = this.list.add(item);
        this.listListeners.itemInserted(this, index);
        return index;
    }

    @Override
    public synchronized void insert(T item, int index) {
        this.list.insert(item, index);
        this.listListeners.itemInserted(this, index);
    }

    @Override
    public synchronized T update(int index, T item) {
        T previousItem = this.list.update(index, item);
        if (previousItem != item) {
            this.listListeners.itemUpdated(this, index, previousItem);
        }
        return previousItem;
    }

    @Override
    public synchronized int remove(T item) {
        int index = this.indexOf(item);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    @Override
    public synchronized Sequence<T> remove(int index, int count) {
        Sequence<T> removed = this.list.remove(index, count);
        if (count > 0) {
            this.listListeners.itemsRemoved(this, index, removed);
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        if (this.list.getLength() > 0) {
            this.list.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public synchronized T get(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized int indexOf(T item) {
        return this.list.indexOf(item);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized int getLength() {
        return this.list.getLength();
    }

    @Override
    public synchronized Comparator<T> getComparator() {
        return this.list.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.list.setComparator(comparator);
        this.listListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.list.iterator());
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        return this.listListeners;
    }

    private static class SynchronizedListListenerList<T>
    extends List.ListListenerList<T> {
        private SynchronizedListListenerList() {
        }

        @Override
        public synchronized void add(ListListener<T> listener) {
            super.add(listener);
        }

        @Override
        public synchronized void remove(ListListener<T> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void itemInserted(List<T> list, int index) {
            super.itemInserted(list, index);
        }

        @Override
        public synchronized void itemsRemoved(List<T> list, int index, Sequence<T> items) {
            super.itemsRemoved(list, index, items);
        }

        @Override
        public synchronized void itemUpdated(List<T> list, int index, T previousItem) {
            super.itemUpdated(list, index, previousItem);
        }

        @Override
        public synchronized void listCleared(List<T> list) {
            super.listCleared(list);
        }

        @Override
        public synchronized void comparatorChanged(List<T> list, Comparator<T> previousComparator) {
            super.comparatorChanged(list, previousComparator);
        }
    }
}

