/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SetAdapter<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = -816891924416727900L;
    private java.util.Set<E> set = null;
    private transient Set.SetListenerList<E> setListeners = new Set.SetListenerList();

    public SetAdapter(java.util.Set<E> set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null.");
        }
        this.set = set;
    }

    public java.util.Set<E> getSet() {
        return this.set;
    }

    @Override
    public boolean add(E element) {
        boolean added = false;
        if (!this.contains(element)) {
            this.set.add(element);
            added = true;
            this.setListeners.elementAdded(this, element);
        }
        return added;
    }

    @Override
    public boolean remove(E element) {
        boolean removed = false;
        if (this.contains(element)) {
            this.set.remove(element);
            removed = false;
            this.setListeners.elementRemoved(this, element);
        }
        return removed;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.set.clear();
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public boolean contains(E element) {
        return this.set.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int getCount() {
        return this.set.size();
    }

    @Override
    public Comparator<E> getComparator() {
        if (this.set instanceof SortedSet) {
            return ((SortedSet)this.set).comparator();
        }
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        Comparator<E> previousComparator = this.getComparator();
        if (this.set instanceof SortedSet) {
            try {
                Constructor<?> constructor = this.set.getClass().getConstructor(Comparator.class);
                if (constructor != null) {
                    SortedSet setLocal = (SortedSet)constructor.newInstance(comparator);
                    setLocal.addAll(this.set);
                    this.set = setLocal;
                }
            }
            catch (SecurityException exception) {
                throw new RuntimeException(exception);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalArgumentException exception) {
                throw new RuntimeException(exception);
            }
            catch (InstantiationException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
        this.setListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(this.set.iterator());
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    public String toString() {
        return this.set.toString();
    }
}

