/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ListenerList;

public interface Map<K, V>
extends Dictionary<K, V>,
Collection<K> {
    @Override
    public V put(K var1, V var2);

    @Override
    public V remove(K var1);

    @Override
    public void clear();

    public int getCount();

    @Override
    public void setComparator(Comparator<K> var1);

    public ListenerList<MapListener<K, V>> getMapListeners();

    public static class MapListenerList<K, V>
    extends ListenerList<MapListener<K, V>>
    implements MapListener<K, V> {
        @Override
        public void valueAdded(Map<K, V> map, K key) {
            for (MapListener listener : this) {
                listener.valueAdded(map, key);
            }
        }

        @Override
        public void valueRemoved(Map<K, V> map, K key, V value) {
            for (MapListener listener : this) {
                listener.valueRemoved(map, key, value);
            }
        }

        @Override
        public void valueUpdated(Map<K, V> map, K key, V previousValue) {
            for (MapListener listener : this) {
                listener.valueUpdated(map, key, previousValue);
            }
        }

        @Override
        public void mapCleared(Map<K, V> map) {
            for (MapListener listener : this) {
                listener.mapCleared(map);
            }
        }

        @Override
        public void comparatorChanged(Map<K, V> map, Comparator<K> previousComparator) {
            for (MapListener listener : this) {
                listener.comparatorChanged(map, previousComparator);
            }
        }
    }
}

