/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ListenerList;

public class HashSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 4095129319373194969L;
    protected HashMap<E, Void> hashMap = new HashMap();
    private transient Set.SetListenerList<E> setListeners = null;

    public HashSet() {
    }

    public HashSet(Set<E> set) {
        for (Object element : set) {
            this.add(element);
        }
    }

    public HashSet(E ... elements) {
        for (int i = 0; i < elements.length; ++i) {
            E element = elements[i];
            this.add(element);
        }
    }

    public HashSet(Comparator<E> comparator) {
        this.setComparator(comparator);
    }

    @Override
    public boolean add(E element) {
        boolean added = false;
        if (!this.hashMap.containsKey(element)) {
            this.hashMap.put(element, null);
            added = true;
            if (this.setListeners != null) {
                this.setListeners.elementAdded(this, element);
            }
        }
        return added;
    }

    @Override
    public boolean remove(E element) {
        boolean removed = false;
        if (this.hashMap.containsKey(element)) {
            this.hashMap.remove(element);
            removed = true;
            if (this.setListeners != null) {
                this.setListeners.elementRemoved(this, element);
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (!this.hashMap.isEmpty()) {
            this.hashMap.clear();
            if (this.setListeners != null) {
                this.setListeners.setCleared(this);
            }
        }
    }

    @Override
    public boolean contains(E element) {
        return this.hashMap.containsKey(element);
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public int getCount() {
        return this.hashMap.getCount();
    }

    @Override
    public Comparator<E> getComparator() {
        return this.hashMap.getComparator();
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        Comparator<E> previousComparator = this.getComparator();
        this.hashMap.setComparator(comparator);
        if (this.setListeners != null) {
            this.setListeners.comparatorChanged(this, previousComparator);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this.hashMap.iterator());
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        if (this.setListeners == null) {
            this.setListeners = new Set.SetListenerList();
        }
        return this.setListeners;
    }

    public boolean equals(Object o) {
        boolean equals;
        block3: {
            block2: {
                equals = false;
                if (this != o) break block2;
                equals = true;
                break block3;
            }
            if (!(o instanceof Set)) break block3;
            Set set = (Set)o;
            if (this.getCount() == set.getCount()) {
                E element;
                Iterator<E> i$ = this.iterator();
                while (i$.hasNext() && (equals = set.contains(element = i$.next()))) {
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 1;
        for (E element : this) {
            hashCode = 31 * hashCode + element.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" (");
        int i = 0;
        for (E element : this) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(element);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private class ElementIterator
    implements Iterator<E> {
        private Iterator<E> iterator;
        private E element = null;

        public ElementIterator(Iterator<E> iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException("iterator is null.");
            }
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element = this.iterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            if (this.element == null) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
            if (HashSet.this.setListeners != null) {
                HashSet.this.setListeners.elementRemoved(HashSet.this, this.element);
            }
            this.element = null;
        }
    }
}

