/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Stack;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ArrayStack<T>
implements Stack<T>,
Serializable {
    private static final long serialVersionUID = 3175064065273930731L;
    private ArrayList<T> arrayList = new ArrayList();
    private transient Stack.StackListenerList<T> stackListeners = new Stack.StackListenerList();

    public ArrayStack() {
        this(null);
    }

    public ArrayStack(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    public ArrayStack(int capacity) {
        this.ensureCapacity(capacity);
    }

    @Override
    public void push(T item) {
        this.arrayList.add(item);
        this.stackListeners.itemPushed(this, item);
    }

    @Override
    public T pop() {
        int length = this.arrayList.getLength();
        if (length == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T item = this.arrayList.remove(length - 1, 1).get(0);
        this.stackListeners.itemPopped(this, item);
        return item;
    }

    @Override
    public T peek() {
        T item = null;
        int length = this.arrayList.getLength();
        if (length > 0) {
            item = this.arrayList.get(length - 1);
        }
        return item;
    }

    @Override
    public void clear() {
        if (this.arrayList.getLength() > 0) {
            this.arrayList.clear();
            this.stackListeners.stackCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.getLength() == 0;
    }

    @Override
    public int getDepth() {
        return this.arrayList.getLength();
    }

    public void ensureCapacity(int capacity) {
        this.arrayList.ensureCapacity(capacity);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.arrayList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.arrayList.setComparator(comparator);
        this.stackListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.arrayList.iterator());
    }

    @Override
    public ListenerList<StackListener<T>> getStackListeners() {
        return this.stackListeners;
    }
}

