/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class ArrayList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 2123086211369612675L;
    private Object[] items;
    private int length = 0;
    private Comparator<T> comparator = null;
    private transient int modificationCount = 0;
    private transient List.ListListenerList<T> listListeners = null;
    public static final int DEFAULT_CAPACITY = 10;

    public ArrayList() {
        this.items = new Object[10];
    }

    public ArrayList(Comparator<T> comparator) {
        this();
        this.comparator = comparator;
    }

    public ArrayList(int capacity) {
        ArrayList.verifyNonNegative("capacity", capacity);
        this.items = new Object[capacity];
    }

    public ArrayList(T ... items) {
        this(items, 0, items.length);
    }

    public ArrayList(T[] items, int index, int count) {
        ArrayList.verifyNotNull("items", items);
        ArrayList.verifyIndexBounds(index, count, 0, items.length);
        this.items = new Object[count];
        System.arraycopy(items, index, this.items, 0, count);
        this.length = count;
    }

    public ArrayList(Sequence<T> items) {
        this(items, 0, items.getLength());
    }

    public ArrayList(Sequence<T> items, int index, int count) {
        ArrayList.verifyNotNull("items", items);
        ArrayList.verifyIndexBounds(index, count, 0, items.getLength());
        this.items = new Object[count];
        for (int i = 0; i < count; ++i) {
            this.items[i] = items.get(index + i);
        }
        this.length = count;
    }

    public ArrayList(ArrayList<T> arrayList) {
        this(arrayList, 0, arrayList.length);
    }

    public ArrayList(ArrayList<T> arrayList, int index, int count) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyIndexBounds(index, count, 0, arrayList.length);
        this.items = new Object[count];
        this.length = count;
        System.arraycopy(arrayList.items, index, this.items, 0, count);
        this.comparator = arrayList.comparator;
    }

    @Override
    public int add(T item) {
        int index = -1;
        if (this.comparator == null) {
            index = this.length;
            this.insert(item, index);
        } else {
            index = ArrayList.binarySearch(this, item, this.comparator);
            if (index < 0) {
                index = -(index + 1);
            }
            this.insert(item, index, false);
        }
        return index;
    }

    @Override
    public void insert(T item, int index) {
        this.insert(item, index, true);
    }

    private void insert(T item, int index, boolean validate) {
        ArrayList.verifyIndexBounds(index, 0, this.length);
        if (this.comparator != null && validate) {
            int i = ArrayList.binarySearch(this, item, this.comparator);
            if (i < 0) {
                i = -(i + 1);
            }
            if (index != i) {
                throw new IllegalArgumentException("Illegal insertion point.");
            }
        }
        this.ensureCapacity(this.length + 1);
        System.arraycopy(this.items, index, this.items, index + 1, this.length - index);
        this.items[index] = item;
        ++this.length;
        ++this.modificationCount;
        if (this.listListeners != null) {
            this.listListeners.itemInserted(this, index);
        }
    }

    @Override
    public T update(int index, T item) {
        ArrayList.verifyIndexBounds(index, 0, this.length - 1);
        Object previousItem = this.items[index];
        if (previousItem != item) {
            if (this.comparator != null) {
                Object successorItem;
                Object predecessorItem = index > 0 ? this.items[index - 1] : null;
                Object object = successorItem = index < this.length - 1 ? this.items[index + 1] : null;
                if (predecessorItem != null && this.comparator.compare(item, predecessorItem) < 0 || successorItem != null && this.comparator.compare(item, successorItem) > 0) {
                    throw new IllegalArgumentException("Illegal item modification.");
                }
            }
            this.items[index] = item;
            ++this.modificationCount;
        }
        if (this.listListeners != null) {
            this.listListeners.itemUpdated(this, index, previousItem);
        }
        return (T)previousItem;
    }

    @Override
    public int remove(T item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index, 1);
        }
        return index;
    }

    @Override
    public Sequence<T> remove(int index, int count) {
        ArrayList.verifyIndexBounds(index, count, 0, this.length);
        ArrayList<Object> removed = new ArrayList<Object>(this.items, index, count);
        if (count > 0) {
            int end = index + count;
            System.arraycopy(this.items, index + count, this.items, index, this.length - end);
            this.length -= count;
            ++this.modificationCount;
            int n = this.length + count;
            for (int i = this.length; i < n; ++i) {
                this.items[i] = null;
            }
            if (this.listListeners != null) {
                this.listListeners.itemsRemoved(this, index, removed);
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.length > 0) {
            this.items = new Object[this.items.length];
            this.length = 0;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.listCleared(this);
            }
        }
    }

    @Override
    public T get(int index) {
        ArrayList.verifyIndexBounds(index, 0, this.length - 1);
        return (T)this.items[index];
    }

    @Override
    public int indexOf(T item) {
        int index = -1;
        if (this.comparator == null) {
            for (index = 0; index < this.length && !(item == null ? this.items[index] == null : item.equals(this.items[index])); ++index) {
            }
            if (index == this.length) {
                index = -1;
            }
        } else {
            index = ArrayList.binarySearch(this, item, this.comparator);
            if (index < 0) {
                index = -1;
            }
        }
        return index;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
        Object[] itemsLocal = new Object[this.length];
        System.arraycopy(this.items, 0, itemsLocal, 0, this.length);
        this.items = itemsLocal;
        this.length = itemsLocal.length;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.items.length) {
            int capacityMax = Math.max(this.items.length * 3 / 2, capacity);
            Object[] itemsLocal = new Object[capacityMax];
            System.arraycopy(this.items, 0, itemsLocal, 0, this.length);
            this.items = itemsLocal;
        }
    }

    public int getCapacity() {
        return this.items.length;
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.items, this.length);
    }

    public T[] toArray(Class<? extends T[]> type) {
        return Arrays.copyOf(this.items, this.length, type);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.comparator;
        if (comparator != null) {
            ArrayList.sort(this, comparator);
        }
        this.comparator = comparator;
        if (this.listListeners != null) {
            this.listListeners.comparatorChanged(this, previousComparator);
        }
    }

    @Override
    public List.ItemIterator<T> iterator() {
        return new ArrayListItemIterator();
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        if (this.listListeners == null) {
            this.listListeners = new List.ListListenerList();
        }
        return this.listListeners;
    }

    public boolean equals(Object o) {
        List list;
        boolean equals = false;
        if (this == o) {
            equals = true;
        } else if (o instanceof List && this.length == (list = (List)o).getLength()) {
            Iterator iterator = list.iterator();
            equals = true;
            for (Object element : this) {
                if (iterator.hasNext() && element.equals(iterator.next())) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 1;
        for (Object item : this) {
            hashCode = 31 * hashCode + (item == null ? 0 : item.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        int i = 0;
        for (Object item : this) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(item);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> void sort(ArrayList<T> arrayList, Comparator<T> comparator) {
        ArrayList.sort(arrayList, 0, arrayList.getLength(), comparator);
    }

    public static <T> void sort(ArrayList<T> arrayList, int from, int to, Comparator<T> comparator) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyNotNull("comparator", comparator);
        Arrays.sort(arrayList.items, from, to, comparator);
        ++arrayList.modificationCount;
    }

    public static <T extends Comparable<? super T>> void sort(ArrayList<T> arrayList) {
        ArrayList.sort(arrayList, new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return t1.compareTo(t2);
            }
        });
    }

    public static <T> int binarySearch(ArrayList<T> arrayList, T item, Comparator<T> comparator) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyNotNull("comparator", comparator);
        ArrayList.verifyNotNull("item", item);
        int index = Arrays.binarySearch(arrayList.items, 0, arrayList.length, item, comparator);
        return index;
    }

    public static <T extends Comparable<? super T>> int binarySearch(ArrayList<T> arrayList, T item) {
        return ArrayList.binarySearch(arrayList, item, new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return t1.compareTo(t2);
            }
        });
    }

    private static void verifyNotNull(String argument, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(argument + " cannot be null.");
        }
    }

    private static void verifyNonNegative(String argument, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(argument + " cannot be negative.");
        }
    }

    private static void verifyIndexBounds(int index, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end (" + end + ") < " + "start (" + start + ")");
        }
        if (index < start || index > end) {
            throw new IndexOutOfBoundsException("index " + index + " out of bounds [" + start + "," + end + "].");
        }
    }

    private static void verifyIndexBounds(int index, int count, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end (" + end + ") < " + "start (" + start + ")");
        }
        if (count < 0 || start < 0) {
            throw new IllegalArgumentException("count (" + count + ") < 0 or start (" + start + ") < 0");
        }
        if (index < start) {
            throw new IndexOutOfBoundsException("index " + index + " out of bounds [" + start + "," + end + "].");
        }
        if (index + count > end) {
            throw new IndexOutOfBoundsException("index + count " + index + "," + count + " out of bounds [" + start + "," + end + "].");
        }
    }

    private class ArrayListItemIterator
    implements List.ItemIterator<T> {
        private int index = 0;
        private int modificationCountLocal;
        private boolean forward = true;

        public ArrayListItemIterator() {
            this.modificationCountLocal = ArrayList.this.modificationCount;
        }

        @Override
        public boolean hasNext() {
            if (this.modificationCountLocal != ArrayList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < ArrayList.this.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.forward = true;
            return ArrayList.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            if (this.modificationCountLocal != ArrayList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.forward = false;
            return ArrayList.this.get(--this.index);
        }

        @Override
        public void toStart() {
            this.index = 0;
        }

        @Override
        public void toEnd() {
            this.index = ArrayList.this.length;
        }

        @Override
        public void insert(T item) {
            this.indexBoundsCheck();
            ArrayList.this.insert(item, this.index);
            ++this.modificationCountLocal;
        }

        @Override
        public void update(T item) {
            this.indexBoundsCheck();
            ArrayList.this.update(this.forward ? this.index - 1 : this.index, item);
            ++this.modificationCountLocal;
        }

        @Override
        public void remove() {
            this.indexBoundsCheck();
            if (this.forward) {
                --this.index;
            }
            ArrayList.this.remove(this.index, 1);
            ++this.modificationCountLocal;
        }

        private void indexBoundsCheck() {
            if (this.index < 0 || this.index > ArrayList.this.length) {
                throw new IllegalStateException("index  " + this.index + " out of bounds");
            }
        }
    }
}

