/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.beans;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.pivot.beans.PropertyNotFoundException;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ListenerList;

public class BeanAdapter
implements Map<String, Object> {
    private Object bean;
    private boolean ignoreReadOnlyProperties;
    private Map.MapListenerList<String, Object> mapListeners = new Map.MapListenerList();
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    private static final String ENUM_VALUE_OF_METHOD_NAME = "valueOf";
    private static final String ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT = "Unable to access property \"%s\" for type %s.";
    private static final String ENUM_COERCION_EXECPTION_MESSAGE = "Unable to coerce %s (\"%s\") to %s.\nValid enum constants - %s";

    public BeanAdapter(Object bean) {
        this(bean, false);
    }

    public BeanAdapter(Object bean, boolean ignoreReadOnlyProperties) {
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        this.bean = bean;
        this.ignoreReadOnlyProperties = ignoreReadOnlyProperties;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Object value = null;
        Method getterMethod = this.getGetterMethod(key);
        if (getterMethod == null) {
            Field field = this.getField(key);
            if (field != null) {
                try {
                    value = field.get(this.bean);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(String.format(ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT, key, this.bean.getClass().getName()), exception);
                }
            }
        } else {
            try {
                value = getterMethod.invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(String.format(ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT, key, this.bean.getClass().getName()), exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(String.format("Error getting property \"%s\" for type %s.", key, this.bean.getClass().getName()), exception.getCause());
            }
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        Class<?> propertyType;
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Method setterMethod = null;
        Object valueUpdated = value;
        if (valueUpdated != null) {
            setterMethod = this.getSetterMethod(key, valueUpdated.getClass());
        }
        if (setterMethod == null && (propertyType = this.getType(key)) != null) {
            setterMethod = this.getSetterMethod(key, propertyType);
            valueUpdated = BeanAdapter.coerce(valueUpdated, propertyType);
        }
        if (setterMethod == null) {
            Class<?> valueType;
            Field field = this.getField(key);
            if (field == null) {
                throw new PropertyNotFoundException("Property \"" + key + "\"" + " does not exist or is read-only.");
            }
            Class<?> fieldType = field.getType();
            if (valueUpdated != null && !fieldType.isAssignableFrom(valueType = valueUpdated.getClass())) {
                valueUpdated = BeanAdapter.coerce(valueUpdated, fieldType);
            }
            try {
                field.set(this.bean, valueUpdated);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(String.format(ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT, key, this.bean.getClass().getName()), exception);
            }
        }
        try {
            setterMethod.invoke(this.bean, valueUpdated);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(String.format(ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT, key, this.bean.getClass().getName()), exception);
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException(String.format("Error setting property \"%s\" for type %s to value \"%s\"", key, this.bean.getClass().getName(), "" + valueUpdated), exception.getCause());
        }
        Object previousValue = null;
        this.mapListeners.valueUpdated(this, key, previousValue);
        return previousValue;
    }

    public void putAll(Map<String, ?> valueMap) {
        for (String key : valueMap) {
            this.put(key, valueMap.get(key));
        }
    }

    public boolean putAll(Map<String, ?> valueMap, boolean ignoreErrors) {
        boolean anyErrors = false;
        for (String key : valueMap) {
            try {
                this.put(key, valueMap.get(key));
            }
            catch (PropertyNotFoundException ex) {
                if (!ignoreErrors) {
                    throw ex;
                }
                anyErrors = true;
            }
        }
        return anyErrors;
    }

    @Override
    public Object remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(String key) {
        boolean containsKey;
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        boolean bl = containsKey = this.getGetterMethod(key) != null;
        if (!containsKey) {
            containsKey = this.getField(key) != null;
        }
        return containsKey;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<String> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<String> comparator) {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(String key) {
        return BeanAdapter.isReadOnly(this.bean.getClass(), key);
    }

    public Class<?> getType(String key) {
        return BeanAdapter.getType(this.bean.getClass(), key);
    }

    public Type getGenericType(String key) {
        return BeanAdapter.getGenericType(this.bean.getClass(), key);
    }

    @Override
    public Iterator<String> iterator() {
        return new PropertyIterator();
    }

    @Override
    public ListenerList<MapListener<String, Object>> getMapListeners() {
        return this.mapListeners;
    }

    private Method getGetterMethod(String key) {
        return BeanAdapter.getGetterMethod(this.bean.getClass(), key);
    }

    private Method getSetterMethod(String key, Class<?> valueType) {
        return BeanAdapter.getSetterMethod(this.bean.getClass(), key, valueType);
    }

    private Field getField(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null.");
        }
        return BeanAdapter.getField(this.bean.getClass(), fieldName);
    }

    public static boolean isReadOnly(Class<?> beanClass, String key) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        boolean isReadOnly = true;
        Method getterMethod = BeanAdapter.getGetterMethod(beanClass, key);
        if (getterMethod == null) {
            Field field = BeanAdapter.getField(beanClass, key);
            if (field != null) {
                isReadOnly = (field.getModifiers() & 0x10) != 0;
            }
        } else {
            Method setterMethod = BeanAdapter.getSetterMethod(beanClass, key, BeanAdapter.getType(beanClass, key));
            isReadOnly = setterMethod == null;
        }
        return isReadOnly;
    }

    public static Class<?> getType(Class<?> beanClass, String key) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Class<?> type = null;
        Method getterMethod = BeanAdapter.getGetterMethod(beanClass, key);
        if (getterMethod == null) {
            Field field = BeanAdapter.getField(beanClass, key);
            if (field != null) {
                type = field.getType();
            }
        } else {
            type = getterMethod.getReturnType();
        }
        return type;
    }

    public static Type getGenericType(Class<?> beanClass, String key) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Type genericType = null;
        Method getterMethod = BeanAdapter.getGetterMethod(beanClass, key);
        if (getterMethod == null) {
            Field field = BeanAdapter.getField(beanClass, key);
            if (field != null) {
                genericType = field.getGenericType();
            }
        } else {
            genericType = getterMethod.getGenericReturnType();
        }
        return genericType;
    }

    public static Field getField(Class<?> beanClass, String key) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Field field = null;
        try {
            field = beanClass.getField(key);
            int modifiers = field.getModifiers();
            if ((modifiers & 1) == 0 || (modifiers & 8) > 0) {
                field = null;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Method getGetterMethod(Class<?> beanClass, String key) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        String keyUpdated = Character.toUpperCase(key.charAt(0)) + key.substring(1);
        Method getterMethod = null;
        try {
            getterMethod = beanClass.getMethod(GET_PREFIX + keyUpdated, new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            // empty catch block
        }
        if (getterMethod == null) {
            try {
                getterMethod = beanClass.getMethod(IS_PREFIX + keyUpdated, new Class[0]);
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
        }
        return getterMethod;
    }

    public static Method getSetterMethod(Class<?> beanClass, String key, Class<?> valueType) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key is empty.");
        }
        Method setterMethod = null;
        if (valueType != null) {
            String keyUpdated = Character.toUpperCase(key.charAt(0)) + key.substring(1);
            String methodName = SET_PREFIX + keyUpdated;
            try {
                setterMethod = beanClass.getMethod(methodName, valueType);
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
            if (setterMethod == null) {
                Class<?> superType = valueType.getSuperclass();
                setterMethod = BeanAdapter.getSetterMethod(beanClass, keyUpdated, superType);
            }
            if (setterMethod == null) {
                try {
                    Field primitiveTypeField = valueType.getField("TYPE");
                    Class primitiveValueType = (Class)primitiveTypeField.get(null);
                    try {
                        setterMethod = beanClass.getMethod(methodName, primitiveValueType);
                    }
                    catch (NoSuchMethodException exception) {}
                }
                catch (NoSuchFieldException exception) {
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(String.format(ILLEGAL_ACCESS_EXCEPTION_MESSAGE_FORMAT, keyUpdated, beanClass.getName()), exception);
                }
            }
            if (setterMethod == null) {
                Class<?>[] interfaces = valueType.getInterfaces();
                int i = 0;
                int n = interfaces.length;
                while (setterMethod == null && i < n) {
                    Class<?> interfaceType = interfaces[i++];
                    setterMethod = BeanAdapter.getSetterMethod(beanClass, keyUpdated, interfaceType);
                }
            }
        }
        return setterMethod;
    }

    public static <T> T coerce(Object value, Class<? extends T> type) {
        Object coercedValue;
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            coercedValue = null;
        } else if (type.isAssignableFrom(value.getClass())) {
            coercedValue = value;
        } else if (type.isEnum()) {
            try {
                String valueString = value.toString().toUpperCase(Locale.ENGLISH);
                Method valueOfMethod = type.getMethod(ENUM_VALUE_OF_METHOD_NAME, String.class);
                coercedValue = valueOfMethod.invoke(null, valueString);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format(ENUM_COERCION_EXECPTION_MESSAGE, value.getClass().getName(), value, type, Arrays.toString(type.getEnumConstants())), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format(ENUM_COERCION_EXECPTION_MESSAGE, value.getClass().getName(), value, type, Arrays.toString(type.getEnumConstants())), e);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(String.format(ENUM_COERCION_EXECPTION_MESSAGE, value.getClass().getName(), value, type, Arrays.toString(type.getEnumConstants())), e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format(ENUM_COERCION_EXECPTION_MESSAGE, value.getClass().getName(), value, type, Arrays.toString(type.getEnumConstants())), e);
            }
        } else if (type == String.class) {
            coercedValue = value.toString();
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            coercedValue = Boolean.parseBoolean(value.toString());
        } else if (type == Character.class || type == Character.TYPE) {
            coercedValue = Character.valueOf(value.toString().charAt(0));
        } else if (type == Byte.class || type == Byte.TYPE) {
            coercedValue = value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : Byte.valueOf(Byte.parseByte(value.toString()));
        } else if (type == Short.class || type == Short.TYPE) {
            coercedValue = value instanceof Number ? Short.valueOf(((Number)value).shortValue()) : Short.valueOf(Short.parseShort(value.toString()));
        } else if (type == Integer.class || type == Integer.TYPE) {
            coercedValue = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(Integer.parseInt(value.toString()));
        } else if (type == Long.class || type == Long.TYPE) {
            coercedValue = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(Long.parseLong(value.toString()));
        } else if (type == Float.class || type == Float.TYPE) {
            coercedValue = value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(Float.parseFloat(value.toString()));
        } else if (type == Double.class || type == Double.TYPE) {
            coercedValue = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(Double.parseDouble(value.toString()));
        } else if (type == BigInteger.class) {
            coercedValue = value instanceof Number ? new BigInteger(((Number)value).toString()) : new BigInteger(value.toString());
        } else if (type == BigDecimal.class) {
            coercedValue = value instanceof Number ? new BigDecimal(((Number)value).toString()) : new BigDecimal(value.toString());
        } else {
            throw new IllegalArgumentException("Unable to coerce " + value.getClass().getName() + " to " + type + ".");
        }
        return (T)coercedValue;
    }

    private class PropertyIterator
    implements Iterator<String> {
        private Method[] methods = null;
        private Field[] fields = null;
        private int i = 0;
        private int j = 0;
        private String nextProperty = null;

        public PropertyIterator() {
            Class<?> type = BeanAdapter.this.bean.getClass();
            this.methods = type.getMethods();
            this.fields = type.getFields();
            this.nextProperty();
        }

        @Override
        public boolean hasNext() {
            return this.nextProperty != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String nextPropertyLocal = this.nextProperty;
            this.nextProperty();
            return nextPropertyLocal;
        }

        private void nextProperty() {
            this.nextProperty = null;
            while (this.i < this.methods.length && this.nextProperty == null) {
                Method method;
                if ((method = this.methods[this.i++]).getParameterTypes().length != 0 || (method.getModifiers() & 8) != 0) continue;
                String methodName = method.getName();
                String prefix = null;
                if (methodName.startsWith(BeanAdapter.GET_PREFIX)) {
                    prefix = BeanAdapter.GET_PREFIX;
                } else if (methodName.startsWith(BeanAdapter.IS_PREFIX)) {
                    prefix = BeanAdapter.IS_PREFIX;
                }
                if (prefix != null) {
                    int propertyOffset = prefix.length();
                    this.nextProperty = Character.toLowerCase(methodName.charAt(propertyOffset)) + methodName.substring(propertyOffset + 1);
                    if (this.nextProperty.equals("class")) {
                        this.nextProperty = null;
                    }
                }
                if (this.nextProperty == null || !BeanAdapter.this.ignoreReadOnlyProperties || !BeanAdapter.this.isReadOnly(this.nextProperty)) continue;
                this.nextProperty = null;
            }
            if (this.nextProperty == null) {
                while (this.j < this.fields.length && this.nextProperty == null) {
                    Field field;
                    int modifiers;
                    if (((modifiers = (field = this.fields[this.j++]).getModifiers()) & 1) != 0 && (modifiers & 8) == 0) {
                        this.nextProperty = field.getName();
                    }
                    if (this.nextProperty == null || !BeanAdapter.this.ignoreReadOnlyProperties || (modifiers & 0x10) == 0) continue;
                    this.nextProperty = null;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

