/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.pivot.wtk.validation.IntValidator;

public class LongRangeValidator
extends IntValidator {
    private long minValue;
    private long maxValue;

    public LongRangeValidator() {
        this.minValue = Long.MIN_VALUE;
        this.maxValue = Long.MAX_VALUE;
    }

    public LongRangeValidator(Locale locale) {
        super(locale);
        this.minValue = Long.MIN_VALUE;
        this.maxValue = Long.MAX_VALUE;
    }

    public LongRangeValidator(long minValue, long maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public LongRangeValidator(Locale locale, long minValue, long maxValue) {
        super(locale);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public long getMinimum() {
        return this.minValue;
    }

    public void setMinimum(long minValue) {
        this.minValue = minValue;
    }

    public long getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(long maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isValid(String text) {
        boolean valid = false;
        if (super.isValid(text)) {
            BigInteger min = BigInteger.valueOf(this.minValue);
            BigInteger max = BigInteger.valueOf(this.maxValue);
            BigInteger value = new BigInteger(text);
            valid = value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
        }
        return valid;
    }
}

