/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.pivot.wtk.validation.IntValidator;

public class IntRangeValidator
extends IntValidator {
    private int minValue;
    private int maxValue;

    public IntRangeValidator() {
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
    }

    public IntRangeValidator(Locale locale) {
        super(locale);
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
    }

    public IntRangeValidator(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public IntRangeValidator(Locale locale, int minValue, int maxValue) {
        super(locale);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void setMinimum(int minValue) {
        this.minValue = minValue;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(int maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isValid(String text) {
        boolean valid = false;
        if (super.isValid(text)) {
            BigInteger min = BigInteger.valueOf(this.minValue);
            BigInteger max = BigInteger.valueOf(this.maxValue);
            BigInteger value = new BigInteger(text);
            valid = value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
        }
        return valid;
    }
}

