/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.TextNodeListener;

public final class TextNode
extends Node {
    private StringBuilder characters = new StringBuilder();
    private TextNodeListenerList textNodeListeners = new TextNodeListenerList();

    public TextNode() {
        this("");
    }

    public TextNode(TextNode textNode) {
        this(textNode.getText());
    }

    public TextNode(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null.");
        }
        this.characters = new StringBuilder(text);
    }

    public String getText() {
        return this.getText(0, this.getCharacterCount());
    }

    public String getText(int beginIndex, int endIndex) {
        return this.characters.substring(beginIndex, endIndex);
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null.");
        }
        this.removeText(0, this.getCharacterCount());
        this.insertText(text, 0);
    }

    public void insertText(CharSequence text, int index) {
        if (text == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (index < 0 || index > this.characters.length()) {
            throw new IndexOutOfBoundsException();
        }
        int characterCount = text.length();
        if (characterCount > 0) {
            this.characters.insert(index, text);
            this.rangeInserted(index, characterCount);
            this.textNodeListeners.charactersInserted(this, index, characterCount);
        }
    }

    public void removeText(int index, int count) {
        if (index < 0 || index + count > this.characters.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (count > 0) {
            this.characters.delete(index, index + count);
            this.textNodeListeners.charactersRemoved(this, index, count);
            this.rangeRemoved(index, count);
        }
    }

    public String getSubstring(Span range) {
        return this.characters.substring(range.start, range.end + 1);
    }

    public String getSubstring(int start, int end) {
        return this.characters.substring(start, end);
    }

    public CharSequence getCharacters() {
        return this.characters;
    }

    public CharSequence getCharacters(int start, int end) {
        return this.characters.subSequence(start, end);
    }

    public CharSequence getCharacters(Span range) {
        return this.characters.subSequence(range.start, range.end + 1);
    }

    @Override
    public char getCharacterAt(int index) {
        if (index < 0 || index >= this.characters.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.characters.charAt(index);
    }

    @Override
    public int getCharacterCount() {
        return this.characters.length();
    }

    @Override
    public void insertRange(Node range, int offset) {
        if (!(range instanceof TextNode)) {
            throw new IllegalArgumentException("range is not a text node.");
        }
        TextNode textNode = (TextNode)range;
        this.insertText(textNode.getText(), offset);
    }

    @Override
    public Node removeRange(int offset, int characterCount) {
        if (characterCount < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        String removed = this.characters.substring(offset, offset + characterCount);
        this.removeText(offset, characterCount);
        TextNode range = new TextNode(removed);
        return range;
    }

    @Override
    public Node getRange(int offset, int characterCount) {
        if (characterCount < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (offset < 0 || offset + characterCount > this.characters.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = offset;
        int end = offset + characterCount;
        String rangeText = this.characters.substring(start, end);
        TextNode textNode = new TextNode(rangeText);
        return textNode;
    }

    @Override
    public Node duplicate(boolean recursive) {
        return new TextNode(this);
    }

    public String toString() {
        return this.getText();
    }

    public ListenerList<TextNodeListener> getTextNodeListeners() {
        return this.textNodeListeners;
    }

    private static class TextNodeListenerList
    extends ListenerList<TextNodeListener>
    implements TextNodeListener {
        private TextNodeListenerList() {
        }

        @Override
        public void charactersInserted(TextNode textNode, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextNodeListener listener = (TextNodeListener)i$.next();
                listener.charactersInserted(textNode, index, count);
            }
        }

        @Override
        public void charactersRemoved(TextNode textNode, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextNodeListener listener = (TextNodeListener)i$.next();
                listener.charactersRemoved(textNode, index, count);
            }
        }
    }
}

