/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.text.ComponentNodeListener;
import org.apache.pivot.wtk.text.Node;

public class ComponentNode
extends Node {
    private Component component = null;
    private ComponentNodeListenerList componentNodeListeners = new ComponentNodeListenerList();

    public ComponentNode() {
    }

    public ComponentNode(ComponentNode componentNode) {
        this.setComponent(componentNode.getComponent());
    }

    public ComponentNode(Component component) {
        this.setComponent(component);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        Component previousComponent = this.component;
        if (previousComponent != component) {
            this.component = component;
            this.componentNodeListeners.componentChanged(this, previousComponent);
        }
    }

    public String getText() {
        return this.getText(this.component);
    }

    private String getText(Component comp) {
        if (comp instanceof TextInput) {
            return ((TextInput)comp).getText();
        }
        if (comp instanceof TextArea) {
            return ((TextArea)comp).getText();
        }
        if (comp instanceof TextPane) {
            return ((TextPane)comp).getText();
        }
        if (comp instanceof Label) {
            return ((Label)comp).getText();
        }
        if (comp instanceof Button) {
            Object buttonData = ((Button)comp).getButtonData();
            if (buttonData instanceof ButtonData) {
                return ((ButtonData)buttonData).getText();
            }
            if (buttonData instanceof String) {
                return (String)buttonData;
            }
            return buttonData.toString();
        }
        if (comp instanceof Container) {
            StringBuilder buf = new StringBuilder();
            for (Component child : (Container)comp) {
                buf.append(this.getText(child));
            }
            return buf.toString();
        }
        return "";
    }

    public String getSubstring(Span range) {
        return this.getText(this.component).substring(range.start, range.end + 1);
    }

    public String getSubstring(int start, int end) {
        return this.getText(this.component).substring(start, end);
    }

    public CharSequence getCharacters(Span range) {
        return this.getText(this.component).subSequence(range.start, range.end + 1);
    }

    public CharSequence getCharacters(int start, int end) {
        return this.getText(this.component).subSequence(start, end);
    }

    @Override
    public char getCharacterAt(int offset) {
        return this.getText(this.component).charAt(offset);
    }

    @Override
    public int getCharacterCount() {
        return this.getText(this.component).length();
    }

    @Override
    public void insertRange(Node range, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeRange(int offset, int span) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getRange(int offset, int characterCount) {
        String componentText = this.getText();
        if (offset < 0 || offset >= componentText.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (characterCount != 1) {
            throw new IllegalArgumentException("Invalid characterCount.");
        }
        return new ComponentNode(this);
    }

    @Override
    public Node duplicate(boolean recursive) {
        return new ComponentNode(this);
    }

    public ListenerList<ComponentNodeListener> getComponentNodeListeners() {
        return this.componentNodeListeners;
    }

    private static class ComponentNodeListenerList
    extends ListenerList<ComponentNodeListener>
    implements ComponentNodeListener {
        private ComponentNodeListenerList() {
        }

        @Override
        public void componentChanged(ComponentNode componentNode, Component previousComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentNodeListener listener = (ComponentNodeListener)i$.next();
                listener.componentChanged(componentNode, previousComponent);
            }
        }
    }
}

