/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkinBlockView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinSpanView;
import org.apache.pivot.wtk.skin.TextPaneSkinTextNodeView;
import org.apache.pivot.wtk.text.Paragraph;

class TextPaneSkinParagraphView
extends TextPaneSkinBlockView {
    private static final int PARAGRAPH_TERMINATOR_WIDTH = 4;
    private ArrayList<Row> rows = null;
    private Bounds terminatorBounds = new Bounds(0, 0, 0, 0);

    public TextPaneSkinParagraphView(Paragraph paragraph) {
        super(paragraph);
    }

    @Override
    public void invalidateUpTree() {
        super.invalidateUpTree();
        this.terminatorBounds = null;
    }

    @Override
    protected void childLayout(int breakWidth) {
        Paragraph paragraph = (Paragraph)this.getNode();
        this.rows = new ArrayList();
        int offset = 0;
        ParagraphChildLayouter layouter = new ParagraphChildLayouter();
        Row row = new Row();
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.layout(Math.max(breakWidth - (row.width + 4), 0));
            int nodeViewWidth = nodeView.getWidth();
            if (row.width + nodeViewWidth > breakWidth && row.width > 0) {
                this.rows.add((Object)row);
                layouter.endRow(row);
                row = new Row();
                row.width = 0;
            }
            RowSegment segment = new RowSegment(nodeView, offset);
            row.rowSegments.add((Object)segment);
            layouter.startSegment(segment);
            offset += nodeView.getCharacterCount();
            row.width += nodeViewWidth;
            nodeView = TextPaneSkinParagraphView.getNext(nodeView);
            while (nodeView != null) {
                this.rows.add((Object)row);
                layouter.endRow(row);
                row = new Row();
                nodeView.layout(breakWidth);
                segment = new RowSegment(nodeView, offset);
                row.rowSegments.add((Object)segment);
                layouter.startSegment(segment);
                offset += nodeView.getCharacterCount();
                row.width = nodeView.getWidth();
                nodeView = TextPaneSkinParagraphView.getNext(nodeView);
            }
        }
        if (row.rowSegments.getLength() > 0) {
            this.rows.add((Object)row);
            layouter.endRow(row);
        }
        layouter.end(paragraph, this.rows);
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.getTextPaneSkin().getFont().getLineMetrics("", 0, 0, fontRenderContext);
        int terminatorHeight = (int)Math.ceil(lm.getHeight());
        int terminatorY = this.getCharacterCount() == 1 ? 0 : layouter.rowY - terminatorHeight;
        this.terminatorBounds = new Bounds(layouter.x, terminatorY, 4, terminatorHeight);
        layouter.paragraphWidth += this.terminatorBounds.width;
        int height = Math.max(layouter.rowY, this.terminatorBounds.height);
        this.setSize(layouter.paragraphWidth, height);
    }

    @Override
    public Dimensions getPreferredSize(int breakWidth) {
        Paragraph paragraph = (Paragraph)this.getNode();
        ArrayList rowsLocal = new ArrayList();
        int offset = 0;
        ParagraphChildLayouter layouter = new ParagraphChildLayouter();
        Row row = new Row();
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.layout(Math.max(breakWidth - (row.width + 4), 0));
            int nodeViewWidth = nodeView.getWidth();
            if (row.width + nodeViewWidth > breakWidth && row.width > 0) {
                rowsLocal.add((Object)row);
                layouter.endRow(row);
                row = new Row();
                row.width = 0;
            }
            RowSegment segment = new RowSegment(nodeView, offset);
            row.rowSegments.add((Object)segment);
            layouter.startSegment(segment);
            offset += nodeView.getCharacterCount();
            row.width += nodeViewWidth;
            nodeView = TextPaneSkinParagraphView.getNext(nodeView);
            while (nodeView != null) {
                rowsLocal.add((Object)row);
                layouter.endRow(row);
                row = new Row();
                nodeView.layout(breakWidth);
                segment = new RowSegment(nodeView, offset);
                row.rowSegments.add((Object)segment);
                layouter.startSegment(segment);
                offset += nodeView.getCharacterCount();
                row.width = nodeView.getWidth();
                nodeView = TextPaneSkinParagraphView.getNext(nodeView);
            }
        }
        if (row.rowSegments.getLength() > 0) {
            rowsLocal.add((Object)row);
            layouter.endRow(row);
        }
        layouter.end(paragraph, (ArrayList<Row>)rowsLocal);
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.getTextPaneSkin().getFont().getLineMetrics("", 0, 0, fontRenderContext);
        int terminatorHeight = (int)Math.ceil(lm.getHeight());
        int terminatorY = this.getCharacterCount() == 1 ? 0 : layouter.rowY - terminatorHeight;
        Bounds terminatorBoundsLocal = new Bounds(layouter.x, terminatorY, 4, terminatorHeight);
        layouter.paragraphWidth += terminatorBoundsLocal.width;
        int height = Math.max(layouter.rowY, terminatorBoundsLocal.height);
        return new Dimensions(layouter.paragraphWidth, height);
    }

    private static TextPaneSkinNodeView getNext(TextPaneSkinNodeView child) {
        if (child instanceof TextPaneSkinSpanView) {
            return ((TextPaneSkinSpanView)child).getNext();
        }
        if (child instanceof TextPaneSkinTextNodeView) {
            return ((TextPaneSkinTextNodeView)child).getNext();
        }
        throw new IllegalStateException();
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
        super.setSkinLocation(skinX, skinY);
        int n = this.rows.getLength();
        for (int i = 0; i < n; ++i) {
            Row row = (Row)this.rows.get(i);
            for (RowSegment segment : row.rowSegments) {
                segment.nodeView.setSkinLocation(skinX + segment.nodeView.getX(), skinY + segment.nodeView.getY());
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        Bounds paintBounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            paintBounds = paintBounds.intersect(clipBounds);
        }
        int n = this.rows.getLength();
        for (int i = 0; i < n; ++i) {
            Row row = (Row)this.rows.get(i);
            for (RowSegment segment : row.rowSegments) {
                this.paintChild(graphics, paintBounds, segment.nodeView);
            }
        }
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        int offset;
        block3: {
            block4: {
                offset = -1;
                int n = this.rows.getLength();
                if (n <= 0) break block4;
                for (int i = 0; i < n; ++i) {
                    block5: {
                        Row row;
                        block7: {
                            block6: {
                                row = (Row)this.rows.get(i);
                                if (y < row.y || y >= row.y + row.height) break block5;
                                if (x >= row.x) break block6;
                                RowSegment firstNodeSegment = (RowSegment)row.rowSegments.get(0);
                                offset = firstNodeSegment.offset;
                                break block5;
                            }
                            if (x <= row.x + row.width - 1) break block7;
                            RowSegment lastNodeSegment = (RowSegment)row.rowSegments.get(row.rowSegments.getLength() - 1);
                            offset = lastNodeSegment.offset + lastNodeSegment.nodeView.getCharacterCount();
                            if (offset >= this.getCharacterCount() - 1) break block5;
                            --offset;
                            break block5;
                        }
                        for (RowSegment segment : row.rowSegments) {
                            Bounds nodeViewBounds = segment.nodeView.getBounds();
                            if (!nodeViewBounds.contains(x, y)) continue;
                            offset = segment.nodeView.getInsertionPoint(x - segment.nodeView.getX(), y - segment.nodeView.getY()) + segment.offset;
                            break;
                        }
                    }
                    if (offset == -1) {
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            offset = this.getCharacterCount() - 1;
        }
        return offset;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = -1;
        int n = this.rows.getLength();
        if (n == 0 && from == -1) {
            offset = 0;
        } else {
            Row row;
            int i;
            if (from == -1) {
                i = direction == TextPane.ScrollDirection.DOWN ? -1 : this.rows.getLength();
            } else if (from == this.getCharacterCount() - 1) {
                i = this.rows.getLength() - 1;
            } else {
                for (i = 0; i < n; ++i) {
                    row = (Row)this.rows.get(i);
                    RowSegment firstNodeSegment = (RowSegment)row.rowSegments.get(0);
                    RowSegment lastNodeSegment = (RowSegment)row.rowSegments.get(row.rowSegments.getLength() - 1);
                    if (from >= firstNodeSegment.offset && from < lastNodeSegment.offset + lastNodeSegment.nodeView.getCharacterCount()) break;
                }
            }
            i = direction == TextPane.ScrollDirection.DOWN ? ++i : --i;
            if (i >= 0 && i < n) {
                row = (Row)this.rows.get(i);
                for (RowSegment segment : row.rowSegments) {
                    Bounds bounds = segment.nodeView.getBounds();
                    if (x < bounds.x || x >= bounds.x + bounds.width) continue;
                    offset = segment.nodeView.getNextInsertionPoint(x - segment.nodeView.getX(), -1, direction) + segment.offset;
                    break;
                }
                if (offset == -1) {
                    RowSegment lastNodeSegment = (RowSegment)row.rowSegments.get(row.rowSegments.getLength() - 1);
                    offset = lastNodeSegment.offset + lastNodeSegment.nodeView.getCharacterCount();
                    if (offset < this.getCharacterCount() - 1) {
                        --offset;
                    }
                }
            }
        }
        return offset;
    }

    @Override
    public int getRowAt(int offset) {
        int rowIndex = -1;
        if (offset == this.getCharacterCount() - 1) {
            rowIndex = this.rows.getLength() == 0 ? 0 : this.rows.getLength() - 1;
        } else {
            int n = this.rows.getLength();
            for (int i = 0; i < n; ++i) {
                Row row = (Row)this.rows.get(i);
                RowSegment firstNodeSegment = (RowSegment)row.rowSegments.get(0);
                RowSegment lastNodeSegment = (RowSegment)row.rowSegments.get(row.rowSegments.getLength() - 1);
                if (offset < firstNodeSegment.offset || offset >= lastNodeSegment.offset + firstNodeSegment.nodeView.getCharacterCount()) continue;
                rowIndex = i;
                break;
            }
        }
        return rowIndex;
    }

    @Override
    public int getRowCount() {
        return Math.max(this.rows.getLength(), 1);
    }

    @Override
    public Bounds getCharacterBounds(int offset) {
        Bounds characterBounds = null;
        if (offset == this.getCharacterCount() - 1) {
            characterBounds = this.terminatorBounds;
        } else {
            if (this.rows != null) {
                int n = this.rows.getLength();
                block0: for (int i = 0; i < n; ++i) {
                    Row row = (Row)this.rows.get(i);
                    for (RowSegment segment : row.rowSegments) {
                        int nodeViewOffset = segment.offset;
                        int characterCount = segment.nodeView.getCharacterCount();
                        if (offset < nodeViewOffset || offset >= nodeViewOffset + characterCount) continue;
                        characterBounds = segment.nodeView.getCharacterBounds(offset - nodeViewOffset);
                        if (characterBounds == null) continue block0;
                        characterBounds = characterBounds.translate(segment.nodeView.getX(), segment.nodeView.getY());
                        continue block0;
                    }
                }
            }
            if (characterBounds != null) {
                characterBounds = characterBounds.intersect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        return characterBounds;
    }

    private static class ParagraphChildLayouter {
        public int x = 0;
        public int paragraphWidth = 0;
        public int rowY = 0;

        private ParagraphChildLayouter() {
        }

        public void startSegment(RowSegment segment) {
            segment.nodeView.setLocation(this.x, segment.nodeView.getY());
            this.x += segment.nodeView.getWidth();
        }

        public void endRow(Row row) {
            row.y = this.rowY;
            for (RowSegment segment : row.rowSegments) {
                row.height = Math.max(row.height, segment.nodeView.getHeight());
            }
            int rowBaseline = -1;
            for (RowSegment segment : row.rowSegments) {
                rowBaseline = Math.max(rowBaseline, segment.nodeView.getBaseline());
            }
            for (RowSegment segment : row.rowSegments) {
                int nodeViewBaseline = segment.nodeView.getBaseline();
                int y = rowBaseline == -1 || nodeViewBaseline == -1 ? row.height - segment.nodeView.getHeight() : rowBaseline - nodeViewBaseline;
                segment.nodeView.setLocation(segment.nodeView.getX(), y + this.rowY);
            }
            this.rowY += row.height;
        }

        public void end(Paragraph paragraph, ArrayList<Row> rows) {
            for (Row row : rows) {
                this.paragraphWidth = Math.max(this.paragraphWidth, row.width);
            }
            for (Row row : rows) {
                if (paragraph.getHorizontalAlignment() == HorizontalAlignment.LEFT) {
                    this.x = 0;
                } else if (paragraph.getHorizontalAlignment() == HorizontalAlignment.CENTER) {
                    this.x = (this.paragraphWidth - row.width) / 2;
                } else if (paragraph.getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
                    this.x = this.paragraphWidth - row.width;
                } else {
                    throw new IllegalStateException();
                }
                for (RowSegment segment : row.rowSegments) {
                    segment.nodeView.setLocation(this.x, segment.nodeView.getY());
                    this.x += segment.nodeView.getWidth();
                }
            }
        }
    }

    private static class RowSegment {
        public TextPaneSkinNodeView nodeView;
        public int offset;

        public RowSegment(TextPaneSkinNodeView nodeView, int offset) {
            this.nodeView = nodeView;
            this.offset = offset;
        }
    }

    private static class Row {
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;
        public ArrayList<RowSegment> rowSegments = new ArrayList();

        private Row() {
        }
    }
}

