/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.text.CharSequenceCharacterIterator;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.skin.TextAreaSkin;

class TextAreaSkinParagraphView
implements TextArea.ParagraphListener {
    private TextAreaSkin textAreaSkin;
    private TextArea.Paragraph paragraph;
    private int x = 0;
    private int y = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private int breakWidth = Integer.MAX_VALUE;
    private int rowOffset = 0;
    private boolean valid = false;
    private ArrayList<Row> rows = new ArrayList();
    private static final int PARAGRAPH_TERMINATOR_WIDTH = 2;

    public TextAreaSkinParagraphView(TextAreaSkin textAreaSkin, TextArea.Paragraph paragraph) {
        this.textAreaSkin = textAreaSkin;
        this.paragraph = paragraph;
    }

    public TextArea.Paragraph getParagraph() {
        return this.paragraph;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public int getWidth() {
        this.validate();
        return (int)Math.ceil(this.width);
    }

    public int getHeight() {
        this.validate();
        return (int)Math.ceil(this.height);
    }

    public int getBreakWidth() {
        return this.breakWidth;
    }

    public void setBreakWidth(int breakWidth) {
        int previousBreakWidth = this.breakWidth;
        if (previousBreakWidth != breakWidth) {
            this.breakWidth = breakWidth;
            this.invalidate();
        }
    }

    public void paint(Graphics2D graphics) {
        TextArea textArea = (TextArea)this.textAreaSkin.getComponent();
        int selectionStart = textArea.getSelectionStart();
        int selectionLength = textArea.getSelectionLength();
        Span selectionRange = new Span(selectionStart, selectionStart + selectionLength - 1);
        int paragraphOffset = this.paragraph.getOffset();
        Span characterRange = new Span(paragraphOffset, paragraphOffset + this.paragraph.getCharacters().length() - 1);
        if (selectionLength > 0 && characterRange.intersects(selectionRange)) {
            boolean focused = textArea.isFocused();
            boolean editable = textArea.isEditable();
            Area selection = this.textAreaSkin.getSelection();
            Area selectedArea = selection.createTransformedArea(AffineTransform.getTranslateInstance(-this.x, -this.y));
            Area unselectedArea = new Area();
            unselectedArea.add(new Area(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height)));
            unselectedArea.subtract(new Area(selectedArea));
            Graphics2D unselectedGraphics = (Graphics2D)graphics.create();
            unselectedGraphics.clip(unselectedArea);
            this.paint(unselectedGraphics, focused, editable, false);
            unselectedGraphics.dispose();
            Graphics2D selectedGraphics = (Graphics2D)graphics.create();
            selectedGraphics.clip(selectedArea);
            this.paint(selectedGraphics, focused, editable, true);
            selectedGraphics.dispose();
        } else {
            this.paint(graphics, textArea.isFocused(), textArea.isEditable(), false);
        }
    }

    private void paint(Graphics2D graphics, boolean focused, boolean editable, boolean selected) {
        Font font = this.textAreaSkin.getFont();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        float rowHeight = ascent + lm.getDescent();
        Rectangle clipBounds = graphics.getClipBounds();
        float rowY = 0.0f;
        int n = this.rows.getLength();
        for (int i = 0; i < n; ++i) {
            Row row = (Row)this.rows.get(i);
            Rectangle2D textBounds = row.glyphVector.getLogicalBounds();
            float rowWidth = (float)textBounds.getWidth();
            if (clipBounds.intersects(new Rectangle2D.Float(0.0f, rowY, rowWidth, rowHeight))) {
                if (selected) {
                    graphics.setPaint(focused && editable ? this.textAreaSkin.getSelectionColor() : this.textAreaSkin.getInactiveSelectionColor());
                } else {
                    graphics.setPaint(this.textAreaSkin.getColor());
                }
                graphics.drawGlyphVector(row.glyphVector, 0.0f, rowY + ascent);
            }
            rowY = (float)((double)rowY + textBounds.getHeight());
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        if (!this.valid) {
            int i;
            this.rows = new ArrayList();
            this.width = 0.0f;
            this.height = 0.0f;
            Font font = this.textAreaSkin.getFont();
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            CharSequence characters = this.paragraph.getCharacters();
            int n = characters.length();
            int start = 0;
            float rowWidth = 0.0f;
            int lastWhitespaceIndex = -1;
            CharSequenceCharacterIterator ci = new CharSequenceCharacterIterator(characters);
            for (i = 0; i < n; ++i) {
                Rectangle2D characterBounds;
                char c = characters.charAt(i);
                if (Character.isWhitespace(c)) {
                    lastWhitespaceIndex = i;
                }
                if (!((rowWidth = (float)((double)rowWidth + (characterBounds = font.getStringBounds((CharacterIterator)ci, i, i + 1, fontRenderContext)).getWidth())) > (float)this.breakWidth)) continue;
                if (lastWhitespaceIndex == -1) {
                    if (start == i) {
                        this.appendLine(characters, start, start + 1, font, fontRenderContext);
                    } else {
                        this.appendLine(characters, start, i, font, fontRenderContext);
                        --i;
                    }
                } else {
                    this.appendLine(characters, start, lastWhitespaceIndex + 1, font, fontRenderContext);
                    i = lastWhitespaceIndex;
                }
                start = i + 1;
                rowWidth = 0.0f;
                lastWhitespaceIndex = -1;
            }
            this.appendLine(characters, start, i, font, fontRenderContext);
            this.width = Math.max(this.width, 2.0f);
        }
        this.valid = true;
    }

    private void appendLine(CharSequence characters, int start, int end, Font font, FontRenderContext fontRenderContext) {
        CharSequenceCharacterIterator line = new CharSequenceCharacterIterator(characters, start, end, start);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, (CharacterIterator)line);
        this.rows.add((Object)new Row(glyphVector, start));
        Rectangle2D textBounds = glyphVector.getLogicalBounds();
        this.width = Math.max(this.width, (float)textBounds.getWidth());
        this.height = (float)((double)this.height + textBounds.getHeight());
    }

    public int getInsertionPoint(int xArgument, int yArgument) {
        Font font = this.textAreaSkin.getFont();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("", fontRenderContext);
        float rowHeight = lm.getAscent() + lm.getDescent();
        int i = (int)Math.floor((float)yArgument / rowHeight);
        int n = this.rows.getLength();
        return i < 0 || i >= n ? -1 : this.getRowInsertionPoint(i, xArgument);
    }

    public int getNextInsertionPoint(int xArgument, int from, TextArea.ScrollDirection direction) {
        int n = this.rows.getLength();
        int i = from == -1 ? (direction == TextArea.ScrollDirection.DOWN ? -1 : n) : this.getRowAt(from);
        i = direction == TextArea.ScrollDirection.DOWN ? ++i : --i;
        return i < 0 || i >= n ? -1 : this.getRowInsertionPoint(i, xArgument);
    }

    private int getRowInsertionPoint(int rowIndex, float xArgument) {
        int index;
        Row row;
        block2: {
            block3: {
                float rowWidth;
                block1: {
                    row = (Row)this.rows.get(rowIndex);
                    Rectangle2D glyphVectorBounds = row.glyphVector.getLogicalBounds();
                    rowWidth = (float)glyphVectorBounds.getWidth();
                    if (!(xArgument < 0.0f)) break block1;
                    index = 0;
                    break block2;
                }
                if (!(xArgument > rowWidth)) break block3;
                index = row.glyphVector.getNumGlyphs();
                if (rowIndex >= this.rows.getLength() - 1) break block2;
                --index;
                break block2;
            }
            int n = row.glyphVector.getNumGlyphs();
            for (index = 0; index < n; ++index) {
                Shape glyphBounds = row.glyphVector.getGlyphLogicalBounds(index);
                Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
                if (!glyphBounds2D.contains(xArgument, glyphBounds2D.getY())) continue;
                if (!((double)xArgument - glyphBounds2D.getX() > glyphBounds2D.getWidth() / 2.0) || index >= n - 1) break;
                ++index;
                break;
            }
        }
        return index + row.offset;
    }

    public int getRowAt(int index) {
        int rowIndex = this.rows.getLength() - 1;
        Row row = (Row)this.rows.get(rowIndex);
        while (row.offset > index) {
            row = (Row)this.rows.get(--rowIndex);
        }
        return rowIndex;
    }

    public int getRowOffset(int index) {
        Row row = (Row)this.rows.get(this.getRowAt(index));
        return row.offset;
    }

    public int getRowLength(int index) {
        Row row = (Row)this.rows.get(this.getRowAt(index));
        return row.glyphVector.getNumGlyphs();
    }

    public int getRowCount() {
        return this.rows.getLength();
    }

    public Bounds getCharacterBounds(int index) {
        int widthLocal;
        int xLocal;
        Row row;
        int rowIndex;
        Bounds characterBounds = null;
        CharSequence characters = this.paragraph.getCharacters();
        int characterCount = characters.length();
        if (index == characterCount) {
            rowIndex = this.rows.getLength() - 1;
            row = (Row)this.rows.get(rowIndex);
            Rectangle2D glyphVectorBounds = row.glyphVector.getLogicalBounds();
            xLocal = (int)Math.floor(glyphVectorBounds.getWidth());
            widthLocal = 2;
        } else {
            rowIndex = this.getRowAt(index);
            row = (Row)this.rows.get(rowIndex);
            Shape glyphBounds = row.glyphVector.getGlyphLogicalBounds(index - row.offset);
            Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
            xLocal = (int)Math.floor(glyphBounds2D.getX());
            widthLocal = (int)Math.ceil(glyphBounds2D.getWidth());
        }
        Font font = this.textAreaSkin.getFont();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("", fontRenderContext);
        float rowHeight = lm.getAscent() + lm.getDescent();
        characterBounds = new Bounds(xLocal, (int)Math.floor((float)rowIndex * rowHeight), widthLocal, (int)Math.ceil(rowHeight));
        return characterBounds;
    }

    @Override
    public void textInserted(TextArea.Paragraph paragraphArgument, int index, int count) {
        this.invalidate();
        this.textAreaSkin.invalidateComponent();
    }

    @Override
    public void textRemoved(TextArea.Paragraph paragraphArgument, int index, int count) {
        this.invalidate();
        this.textAreaSkin.invalidateComponent();
    }

    private static class Row {
        public final GlyphVector glyphVector;
        public final int offset;

        public Row(GlyphVector glyphVector, int offset) {
            this.glyphVector = glyphVector;
            this.offset = offset;
        }
    }
}

