/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.effects.Decorator;

public class ShadeDecorator
implements Decorator {
    private float opacity;
    private Color color;
    private Component component;
    private Graphics2D graphics;

    public ShadeDecorator() {
        this(0.33f, Color.BLACK);
    }

    public ShadeDecorator(float opacity, Color color) {
        if (opacity <= 0.0f || opacity >= 1.0f) {
            throw new IllegalArgumentException("opacity must be between 0 and 1, exclusive.");
        }
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.opacity = opacity;
        this.color = color;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setOpacity(Number opacity) {
        if (opacity == null) {
            throw new IllegalArgumentException("opacity is null.");
        }
        this.setOpacity(opacity.floatValue());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    @Override
    public Graphics2D prepare(Component componentArgument, Graphics2D graphicsArgument) {
        this.component = componentArgument;
        this.graphics = graphicsArgument;
        return graphicsArgument;
    }

    @Override
    public void update() {
        this.graphics.setComposite(AlphaComposite.getInstance(3, this.opacity));
        this.graphics.setColor(this.color);
        this.graphics.fillRect(0, 0, this.component.getWidth(), this.component.getHeight());
        this.component = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component componentArgument) {
        return new Bounds(0, 0, componentArgument.getWidth(), componentArgument.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component componentArgument) {
        return new AffineTransform();
    }
}

