/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.net.URL;
import org.apache.pivot.wtk.media.Image;

public class TableViewHeaderData {
    private Image icon = null;
    private String text = null;

    public TableViewHeaderData() {
        this(null, null);
    }

    public TableViewHeaderData(Image icon) {
        this(icon, null);
    }

    public TableViewHeaderData(String text) {
        this(null, text);
    }

    public TableViewHeaderData(Image icon, String text) {
        this.icon = icon;
        this.text = text;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setIcon(URL iconURL) {
        if (iconURL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        this.setIcon(Image.loadFromCache(iconURL));
    }

    public void setIcon(String iconName) {
        if (iconName == null) {
            throw new IllegalArgumentException("iconName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(iconName.substring(1));
        if (url == null) {
            throw new IllegalArgumentException("cannot find icon resource " + iconName);
        }
        this.setIcon(url);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

