/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.content.MenuItemData;
import org.apache.pivot.wtk.media.Image;

public class MenuItemDataRenderer
extends TablePane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label textLabel = new Label();
    protected Label keyboardShortcutLabel = new Label();

    public MenuItemDataRenderer() {
        this.getStyles().put("padding", (Object)new Insets(2));
        this.getColumns().add(new TablePane.Column(1, true));
        this.getColumns().add(new TablePane.Column());
        BoxPane boxPane = new BoxPane();
        boxPane.add(this.imageView);
        boxPane.add(this.textLabel);
        boxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        boxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 6));
        TablePane.Row row = new TablePane.Row();
        row.add(boxPane);
        row.add(this.keyboardShortcutLabel);
        this.getRows().add(row);
        this.imageView.getStyles().put("backgroundColor", null);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object data, Button button, boolean highlighted) {
        Image icon = null;
        String text = null;
        Keyboard.KeyStroke keyboardShortcut = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            icon = buttonData.getIcon();
            if (buttonData instanceof MenuItemData) {
                MenuItemData menuItemData = (MenuItemData)buttonData;
                keyboardShortcut = menuItemData.getKeyboardShortcut();
            }
        } else if (data instanceof Image) {
            icon = (Image)data;
        }
        text = this.toString(data);
        if (button.isSelected()) {
            icon = (Image)button.getStyles().get("checkmarkImage");
        }
        Menu.Item menuItem = (Menu.Item)button;
        Menu menu = (Menu)menuItem.getParent();
        int margin = (Integer)menu.getStyles().get("margin");
        Insets padding = (Insets)this.getStyles().get("padding");
        this.imageView.setImage(icon);
        this.imageView.setPreferredWidth(margin - padding.left * 2);
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
        this.textLabel.setText(text != null ? text : "");
        Font font = (Font)menu.getStyles().get("font");
        this.textLabel.getStyles().put("font", (Object)font);
        this.keyboardShortcutLabel.getStyles().put("font", (Object)font.deriveFont(2));
        Color color = button.isEnabled() ? (highlighted ? (Color)menu.getStyles().get("activeColor") : (Color)menu.getStyles().get("color")) : (Color)menu.getStyles().get("disabledColor");
        this.textLabel.getStyles().put("color", (Object)color);
        this.keyboardShortcutLabel.getStyles().put("color", (Object)color);
        boolean showKeyboardShortcuts = false;
        if (menu.getStyles().containsKey("showKeyboardShortcuts")) {
            showKeyboardShortcuts = (Boolean)menu.getStyles().get("showKeyboardShortcuts");
        }
        if (showKeyboardShortcuts) {
            this.keyboardShortcutLabel.setVisible(true);
            this.keyboardShortcutLabel.setText(keyboardShortcut != null ? keyboardShortcut.toString() : "");
        } else {
            this.keyboardShortcutLabel.setVisible(false);
        }
    }

    @Override
    public String toString(Object data) {
        String string = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            string = buttonData.getText();
        } else if (!(data instanceof Image) && data != null) {
            string = data.toString();
        }
        return string;
    }
}

