/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.WTKListenerList;

@DefaultProperty(value="view")
public abstract class Viewport
extends Container {
    private int scrollTop = 0;
    private int scrollLeft = 0;
    private Component view;
    private boolean consumeRepaint = false;
    private boolean repaintAllViewport = false;
    private ViewportListenerList viewportListeners = new ViewportListenerList();

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public int getScrollTop() {
        return this.scrollTop;
    }

    public void setScrollTop(int scrollTop) {
        int previousScrollTop = this.scrollTop;
        if (scrollTop != previousScrollTop) {
            this.scrollTop = scrollTop;
            this.viewportListeners.scrollTopChanged(this, previousScrollTop);
        }
    }

    public int getScrollLeft() {
        return this.scrollLeft;
    }

    public void setScrollLeft(int scrollLeft) {
        int previousScrollLeft = this.scrollLeft;
        if (scrollLeft != previousScrollLeft) {
            this.scrollLeft = scrollLeft;
            this.viewportListeners.scrollLeftChanged(this, previousScrollLeft);
        }
    }

    public Component getView() {
        return this.view;
    }

    public void setView(Component view) {
        Component previousView = this.view;
        if (view != previousView) {
            this.view = null;
            if (previousView != null) {
                this.remove(previousView);
            }
            if (view != null) {
                this.insert(view, 0);
            }
            this.view = view;
            this.viewportListeners.viewChanged(this, previousView);
        }
    }

    public boolean isConsumeRepaint() {
        return this.consumeRepaint;
    }

    public void setConsumeRepaint(boolean consumeRepaint) {
        this.consumeRepaint = consumeRepaint;
    }

    public Bounds getViewportBounds() {
        Skin viewportSkin = (Skin)((Object)this.getSkin());
        return viewportSkin.getViewportBounds();
    }

    @Override
    public void repaint(int x, int y, int width, int height, boolean immediate) {
        if (!this.consumeRepaint) {
            super.repaint(x, y, width, height, immediate);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.view) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<ViewportListener> getViewportListeners() {
        return this.viewportListeners;
    }

    public boolean isRepaintAllViewport() {
        return this.repaintAllViewport;
    }

    public void setRepaintAllViewport(boolean repaintAllViewport) {
        this.repaintAllViewport = repaintAllViewport;
    }

    private static class ViewportListenerList
    extends WTKListenerList<ViewportListener>
    implements ViewportListener {
        private ViewportListenerList() {
        }

        @Override
        public void scrollTopChanged(Viewport viewport, int previousScrollTop) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ViewportListener listener = (ViewportListener)i$.next();
                listener.scrollTopChanged(viewport, previousScrollTop);
            }
        }

        @Override
        public void scrollLeftChanged(Viewport viewport, int previousScrollLeft) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ViewportListener listener = (ViewportListener)i$.next();
                listener.scrollLeftChanged(viewport, previousScrollLeft);
            }
        }

        @Override
        public void viewChanged(Viewport viewport, Component previousView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ViewportListener listener = (ViewportListener)i$.next();
                listener.viewChanged(viewport, previousView);
            }
        }
    }

    public static interface Skin {
        public Bounds getViewportBounds();
    }
}

