/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.TablePaneAttributeListener;
import org.apache.pivot.wtk.TablePaneListener;
import org.apache.pivot.wtk.WTKListenerList;

@DefaultProperty(value="rows")
public class TablePane
extends Container {
    private ArrayList<Row> rows = null;
    private RowSequence rowSequence = new RowSequence();
    private ArrayList<Column> columns = null;
    private ColumnSequence columnSequence = new ColumnSequence();
    private TablePaneListenerList tablePaneListeners = new TablePaneListenerList();
    private TablePaneAttributeListenerList tablePaneAttributeListeners = new TablePaneAttributeListenerList();
    public static final String RELATIVE_SIZE_INDICATOR = "*";

    public TablePane() {
        this((Sequence<Column>)new ArrayList());
    }

    public TablePane(Sequence<Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns is null");
        }
        this.rows = new ArrayList();
        this.columns = new ArrayList(columns);
        this.installSkin(TablePane.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public RowSequence getRows() {
        return this.rowSequence;
    }

    public int getRowAt(int y) {
        Skin tablePaneSkin = (Skin)((Object)this.getSkin());
        return tablePaneSkin.getRowAt(y);
    }

    public Bounds getRowBounds(int row) {
        Skin tablePaneSkin = (Skin)((Object)this.getSkin());
        return tablePaneSkin.getRowBounds(row);
    }

    public ColumnSequence getColumns() {
        return this.columnSequence;
    }

    public int getColumnAt(int x) {
        Skin tablePaneSkin = (Skin)((Object)this.getSkin());
        return tablePaneSkin.getColumnAt(x);
    }

    public Bounds getColumnBounds(int column) {
        Skin tablePaneSkin = (Skin)((Object)this.getSkin());
        return tablePaneSkin.getColumnBounds(column);
    }

    public Component getCellComponent(int rowIndex, int columnIndex) {
        Row row = (Row)this.rows.get(rowIndex);
        Component component = null;
        if (row.getLength() > columnIndex) {
            component = row.get(columnIndex);
        }
        return component;
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            for (Row row : this.rows) {
                if (row.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(index, count);
    }

    public ListenerList<TablePaneListener> getTablePaneListeners() {
        return this.tablePaneListeners;
    }

    public ListenerList<TablePaneAttributeListener> getTablePaneAttributeListeners() {
        return this.tablePaneAttributeListeners;
    }

    public static int getRowSpan(Component component) {
        Integer value = (Integer)component.getAttribute(Attribute.ROW_SPAN);
        return value == null ? 1 : value;
    }

    public static void setRowSpan(Component component, int rowSpan) {
        Container parent;
        int previousRowSpan;
        Integer previousValue = (Integer)component.setAttribute(Attribute.ROW_SPAN, rowSpan);
        int n = previousRowSpan = previousValue == null ? 1 : previousValue;
        if (previousRowSpan != rowSpan && (parent = component.getParent()) instanceof TablePane) {
            TablePane tablePane = (TablePane)parent;
            tablePane.tablePaneAttributeListeners.rowSpanChanged(tablePane, component, previousRowSpan);
        }
    }

    public static int getColumnSpan(Component component) {
        Integer value = (Integer)component.getAttribute(Attribute.COLUMN_SPAN);
        return value == null ? 1 : value;
    }

    public static void setColumnSpan(Component component, int columnSpan) {
        Container parent;
        int previousColumnSpan;
        Integer previousValue = (Integer)component.setAttribute(Attribute.COLUMN_SPAN, columnSpan);
        int n = previousColumnSpan = previousValue == null ? 1 : previousValue;
        if (previousColumnSpan != columnSpan && (parent = component.getParent()) instanceof TablePane) {
            TablePane tablePane = (TablePane)parent;
            tablePane.tablePaneAttributeListeners.columnSpanChanged(tablePane, component, previousColumnSpan);
        }
    }

    private static class TablePaneAttributeListenerList
    extends WTKListenerList<TablePaneAttributeListener>
    implements TablePaneAttributeListener {
        private TablePaneAttributeListenerList() {
        }

        @Override
        public void rowSpanChanged(TablePane tablePane, Component component, int previousRowSpan) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneAttributeListener listener = (TablePaneAttributeListener)i$.next();
                listener.rowSpanChanged(tablePane, component, previousRowSpan);
            }
        }

        @Override
        public void columnSpanChanged(TablePane tablePane, Component component, int previousColumnSpan) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneAttributeListener listener = (TablePaneAttributeListener)i$.next();
                listener.columnSpanChanged(tablePane, component, previousColumnSpan);
            }
        }
    }

    private static class TablePaneListenerList
    extends WTKListenerList<TablePaneListener>
    implements TablePaneListener {
        private TablePaneListenerList() {
        }

        @Override
        public void rowInserted(TablePane tablePane, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.rowInserted(tablePane, index);
            }
        }

        @Override
        public void rowsRemoved(TablePane tablePane, int index, Sequence<Row> rows) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.rowsRemoved(tablePane, index, rows);
            }
        }

        @Override
        public void rowHeightChanged(Row row, int previousHeight, boolean previousRelative) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.rowHeightChanged(row, previousHeight, previousRelative);
            }
        }

        @Override
        public void rowHighlightedChanged(Row row) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.rowHighlightedChanged(row);
            }
        }

        @Override
        public void columnInserted(TablePane tablePane, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.columnInserted(tablePane, index);
            }
        }

        @Override
        public void columnsRemoved(TablePane tablePane, int index, Sequence<Column> columns) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.columnsRemoved(tablePane, index, columns);
            }
        }

        @Override
        public void columnWidthChanged(Column column, int previousWidth, boolean previousRelative) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.columnWidthChanged(column, previousWidth, previousRelative);
            }
        }

        @Override
        public void columnHighlightedChanged(Column column) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.columnHighlightedChanged(column);
            }
        }

        @Override
        public void cellInserted(Row row, int column) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.cellInserted(row, column);
            }
        }

        @Override
        public void cellsRemoved(Row row, int column, Sequence<Component> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.cellsRemoved(row, column, removed);
            }
        }

        @Override
        public void cellUpdated(Row row, int column, Component previousComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TablePaneListener listener = (TablePaneListener)i$.next();
                listener.cellUpdated(row, column, previousComponent);
            }
        }
    }

    private static enum Attribute {
        ROW_SPAN,
        COLUMN_SPAN;

    }

    public static final class Filler
    extends Component {
        public Filler() {
            this.installSkin(Filler.class);
        }
    }

    public final class ColumnSequence
    implements Sequence<Column>,
    Iterable<Column> {
        private ColumnSequence() {
        }

        public int add(Column column) {
            int index = this.getLength();
            this.insert(column, index);
            return index;
        }

        public void insert(Column column, int index) {
            if (column == null) {
                throw new IllegalArgumentException("column is null.");
            }
            if (column.tablePane != null) {
                throw new IllegalArgumentException("column is already in use by another table pane.");
            }
            TablePane.this.columns.insert((Object)column, index);
            column.tablePane = TablePane.this;
            TablePane.this.tablePaneListeners.columnInserted(TablePane.this, index);
        }

        public Column update(int index, Column column) {
            throw new UnsupportedOperationException();
        }

        public int remove(Column column) {
            int index = this.indexOf(column);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Column> remove(int index, int count) {
            Sequence removed = TablePane.this.columns.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Column column = (Column)removed.get(i);
                    column.tablePane = null;
                }
                TablePane.this.tablePaneListeners.columnsRemoved(TablePane.this, index, (Sequence<Column>)removed);
            }
            return removed;
        }

        public Column get(int index) {
            return (Column)TablePane.this.columns.get(index);
        }

        public int indexOf(Column column) {
            return TablePane.this.columns.indexOf((Object)column);
        }

        public int getLength() {
            return TablePane.this.columns.getLength();
        }

        @Override
        public Iterator<Column> iterator() {
            return new ImmutableIterator((Iterator)TablePane.this.columns.iterator());
        }
    }

    public final class RowSequence
    implements Sequence<Row>,
    Iterable<Row> {
        private RowSequence() {
        }

        public int add(Row row) {
            int index = this.getLength();
            this.insert(row, index);
            return index;
        }

        public void insert(Row row, int index) {
            if (row == null) {
                throw new IllegalArgumentException("row is null.");
            }
            if (row.tablePane != null) {
                throw new IllegalArgumentException("row is already in use by another table pane.");
            }
            TablePane.this.rows.insert((Object)row, index);
            row.tablePane = TablePane.this;
            int n = row.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = row.get(i);
                TablePane.this.add(component);
            }
            TablePane.this.tablePaneListeners.rowInserted(TablePane.this, index);
        }

        public Row update(int index, Row row) {
            throw new UnsupportedOperationException();
        }

        public int remove(Row row) {
            int index = this.indexOf(row);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Row> remove(int index, int count) {
            Sequence removed = TablePane.this.rows.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Row row = (Row)removed.get(i);
                    row.tablePane = null;
                    int m = row.getLength();
                    for (int j = 0; j < m; ++j) {
                        Component component = row.get(j);
                        TablePane.this.remove(component);
                    }
                }
                TablePane.this.tablePaneListeners.rowsRemoved(TablePane.this, index, (Sequence<Row>)removed);
            }
            return removed;
        }

        public Row get(int index) {
            return (Row)TablePane.this.rows.get(index);
        }

        public int indexOf(Row row) {
            return TablePane.this.rows.indexOf((Object)row);
        }

        public int getLength() {
            return TablePane.this.rows.getLength();
        }

        @Override
        public Iterator<Row> iterator() {
            return new ImmutableIterator((Iterator)TablePane.this.rows.iterator());
        }
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public Bounds getRowBounds(int var1);

        public int getColumnAt(int var1);

        public Bounds getColumnBounds(int var1);
    }

    public static class Column {
        private TablePane tablePane = null;
        private int width;
        private boolean relative;
        private boolean highlighted;

        public Column() {
            this(-1, false, false);
        }

        public Column(int width) {
            this(width, false, false);
        }

        public Column(int width, boolean relative) {
            this(width, relative, false);
        }

        public Column(int width, boolean relative, boolean highlighted) {
            this.width = width;
            this.relative = relative;
            this.highlighted = highlighted;
        }

        public TablePane getTablePane() {
            return this.tablePane;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setWidth(int width) {
            this.setWidth(width, false);
        }

        public void setWidth(String width) {
            boolean relativeLocal = false;
            if (width.endsWith(TablePane.RELATIVE_SIZE_INDICATOR)) {
                relativeLocal = true;
                this.setWidth(Integer.parseInt(width.substring(0, width.length() - 1)), relativeLocal);
            } else {
                this.setWidth(Integer.parseInt(width), relativeLocal);
            }
        }

        public void setWidth(int width, boolean relative) {
            int previousWidth = this.width;
            boolean previousRelative = this.relative;
            if (previousWidth != width || previousRelative != relative) {
                this.width = width;
                this.relative = relative;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.columnWidthChanged(this, previousWidth, previousRelative);
                }
            }
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setHighlighted(boolean highlighted) {
            if (highlighted != this.highlighted) {
                this.highlighted = highlighted;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.columnHighlightedChanged(this);
                }
            }
        }
    }

    public static class Row
    implements Sequence<Component>,
    Iterable<Component> {
        private int height;
        private boolean relative;
        private boolean highlighted;
        private ArrayList<Component> cells = new ArrayList();
        private TablePane tablePane = null;

        public Row() {
            this(-1, false, false);
        }

        public Row(int height) {
            this(height, false, false);
        }

        public Row(int height, boolean relative) {
            this(height, relative, false);
        }

        public Row(int height, boolean relative, boolean highlighted) {
            this.height = height;
            this.relative = relative;
            this.highlighted = highlighted;
        }

        public TablePane getTablePane() {
            return this.tablePane;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setHeight(int height) {
            this.setHeight(height, false);
        }

        public void setHeight(String height) {
            boolean relativeLocal = false;
            if (height.endsWith(TablePane.RELATIVE_SIZE_INDICATOR)) {
                relativeLocal = true;
                this.setHeight(Integer.parseInt(height.substring(0, height.length() - 1)), relativeLocal);
            } else {
                this.setHeight(Integer.parseInt(height), relativeLocal);
            }
        }

        public void setHeight(int height, boolean relative) {
            int previousHeight = this.height;
            boolean previousRelative = this.relative;
            if (previousHeight != height || previousRelative != relative) {
                this.height = height;
                this.relative = relative;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.rowHeightChanged(this, previousHeight, previousRelative);
                }
            }
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setHighlighted(boolean highlighted) {
            if (highlighted != this.highlighted) {
                this.highlighted = highlighted;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.rowHighlightedChanged(this);
                }
            }
        }

        public int add(Component component) {
            int index = this.getLength();
            this.insert(component, index);
            return index;
        }

        public void insert(Component component, int index) {
            if (component == null) {
                throw new IllegalArgumentException("Component is null.");
            }
            if (component.getParent() != null) {
                throw new IllegalArgumentException("Component already has a parent.");
            }
            this.cells.insert((Object)component, index);
            if (this.tablePane != null) {
                this.tablePane.add(component);
                this.tablePane.tablePaneListeners.cellInserted(this, index);
            }
        }

        public Component update(int index, Component component) {
            Component previousComponent = (Component)this.cells.get(index);
            if (component != previousComponent) {
                if (component == null) {
                    throw new IllegalArgumentException("Component is null.");
                }
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.cells.update(index, (Object)component);
                if (this.tablePane != null) {
                    this.tablePane.add(component);
                    this.tablePane.tablePaneListeners.cellUpdated(this, index, previousComponent);
                    this.tablePane.remove(previousComponent);
                }
            }
            return previousComponent;
        }

        public int remove(Component component) {
            int index = this.indexOf(component);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Component> remove(int index, int count) {
            Sequence removed = this.cells.remove(index, count);
            if (this.tablePane != null) {
                this.tablePane.tablePaneListeners.cellsRemoved(this, index, (Sequence<Component>)removed);
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = (Component)removed.get(i);
                    this.tablePane.remove(component);
                }
            }
            return removed;
        }

        public Component get(int index) {
            return (Component)this.cells.get(index);
        }

        public int indexOf(Component component) {
            return this.cells.indexOf((Object)component);
        }

        public int getLength() {
            return this.cells.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.cells.iterator());
        }
    }
}

