/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.wtk.Span;

public class RangeSelection {
    private ArrayList<Span> selectedRanges = new ArrayList();
    private static final Comparator<Span> START_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span range1, Span range2) {
            return range1.end - range2.start;
        }
    };
    private static final Comparator<Span> END_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span range1, Span range2) {
            return range1.start - range2.end;
        }
    };
    private static final Comparator<Span> INTERSECTION_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span range1, Span range2) {
            return range1.start > range2.end ? 1 : (range2.start > range1.end ? -1 : 0);
        }
    };

    public Sequence<Span> addRange(int start, int end) {
        ArrayList addedRanges = new ArrayList();
        Span range = RangeSelection.normalize(start, end);
        assert (range.start >= 0);
        int n = this.selectedRanges.getLength();
        if (n == 0) {
            this.selectedRanges.add((Object)range);
            addedRanges.add((Object)range);
        } else {
            int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, START_COMPARATOR);
            if (i < 0) {
                i = -(i + 1);
            }
            if (i > 0) {
                Span previousRange = (Span)this.selectedRanges.get(i - 1);
                if (range.start == previousRange.end + 1) {
                    --i;
                }
            }
            if (i == n) {
                this.selectedRanges.add((Object)range);
                addedRanges.add((Object)range);
            } else {
                int j = ArrayList.binarySearch(this.selectedRanges, (Object)range, END_COMPARATOR);
                j = j < 0 ? -(j + 1) : ++j;
                if (j < n) {
                    Span nextRange = (Span)this.selectedRanges.get(j);
                    if (range.end == nextRange.start - 1) {
                        ++j;
                    }
                }
                if (i == j) {
                    this.selectedRanges.insert((Object)range, i);
                    addedRanges.add((Object)range);
                } else {
                    Span lowerRange = (Span)this.selectedRanges.get(i);
                    Span upperRange = (Span)this.selectedRanges.get(j - 1);
                    range = new Span(Math.min(range.start, lowerRange.start), Math.max(range.end, upperRange.end));
                    if (range.start < lowerRange.start) {
                        addedRanges.add((Object)new Span(range.start, lowerRange.start - 1));
                    }
                    for (int k = i; k < j - 1; ++k) {
                        Span selectedRange = (Span)this.selectedRanges.get(k);
                        Span nextSelectedRange = (Span)this.selectedRanges.get(k + 1);
                        addedRanges.add((Object)new Span(selectedRange.end + 1, nextSelectedRange.start - 1));
                    }
                    if (range.end > upperRange.end) {
                        addedRanges.add((Object)new Span(upperRange.end + 1, range.end));
                    }
                    this.selectedRanges.update(i, (Object)range);
                    if (i < j) {
                        this.selectedRanges.remove(i + 1, j - i - 1);
                    }
                }
            }
        }
        return addedRanges;
    }

    public Sequence<Span> removeRange(int start, int end) {
        ArrayList removedRanges = new ArrayList();
        Span range = RangeSelection.normalize(start, end);
        assert (range.start >= 0);
        int n = this.selectedRanges.getLength();
        if (n > 0) {
            int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, START_COMPARATOR);
            if (i < 0) {
                i = -(i + 1);
            }
            if (i < n) {
                Span lowerRange = (Span)this.selectedRanges.get(i);
                if (lowerRange.start < range.start && lowerRange.end > range.end) {
                    this.selectedRanges.update(i, (Object)new Span(lowerRange.start, range.start - 1));
                    this.selectedRanges.insert((Object)new Span(range.end + 1, lowerRange.end), i + 1);
                    removedRanges.add((Object)range);
                } else {
                    int j;
                    Span leadingRemovedRange = null;
                    if (range.start > lowerRange.start) {
                        this.selectedRanges.update(i, (Object)new Span(lowerRange.start, range.start - 1));
                        leadingRemovedRange = new Span(range.start, lowerRange.end);
                        ++i;
                    }
                    j = (j = ArrayList.binarySearch(this.selectedRanges, (Object)range, END_COMPARATOR)) < 0 ? -(j + 1) : ++j;
                    if (j > 0) {
                        Span upperRange = (Span)this.selectedRanges.get(j - 1);
                        Span trailingRemovedRange = null;
                        if (range.end < upperRange.end) {
                            this.selectedRanges.update(j - 1, (Object)new Span(range.end + 1, upperRange.end));
                            trailingRemovedRange = new Span(upperRange.start, range.end);
                            --j;
                        }
                        Sequence clearedRanges = this.selectedRanges.remove(i, j - i);
                        if (leadingRemovedRange != null) {
                            removedRanges.add((Object)leadingRemovedRange);
                        }
                        int c = clearedRanges.getLength();
                        for (int k = 0; k < c; ++k) {
                            removedRanges.add(clearedRanges.get(k));
                        }
                        if (trailingRemovedRange != null) {
                            removedRanges.add(trailingRemovedRange);
                        }
                    }
                }
            }
        }
        return removedRanges;
    }

    public void clear() {
        this.selectedRanges.clear();
    }

    public Span get(int index) {
        return (Span)this.selectedRanges.get(index);
    }

    public int getLength() {
        return this.selectedRanges.getLength();
    }

    public ImmutableList<Span> getSelectedRanges() {
        return new ImmutableList(this.selectedRanges);
    }

    public int indexOf(Span range) {
        assert (range != null);
        int index = -1;
        int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, INTERSECTION_COMPARATOR);
        if (i >= 0) {
            index = range.equals(this.selectedRanges.get(i)) ? i : -1;
        }
        return index;
    }

    public boolean containsIndex(int index) {
        Span range = new Span(index);
        int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, INTERSECTION_COMPARATOR);
        return i >= 0;
    }

    public int insertIndex(int index) {
        int updated = 0;
        Span range = new Span(index);
        int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, INTERSECTION_COMPARATOR);
        if (i < 0) {
            i = -(i + 1);
        } else {
            Span selectedRange = (Span)this.selectedRanges.get(i);
            if (selectedRange.start < index) {
                this.selectedRanges.update(i, (Object)new Span(selectedRange.start, selectedRange.end + 1));
                ++i;
            }
        }
        int n = this.selectedRanges.getLength();
        while (i < n) {
            Span selectedRange = (Span)this.selectedRanges.get(i);
            this.selectedRanges.update(i, (Object)new Span(selectedRange.start + 1, selectedRange.end + 1));
            ++updated;
            ++i;
        }
        return updated;
    }

    public int removeIndexes(int index, int count) {
        Sequence<Span> removed = this.removeRange(index, index + count - 1);
        int updated = removed.getLength();
        Span range = new Span(index);
        int i = ArrayList.binarySearch(this.selectedRanges, (Object)range, INTERSECTION_COMPARATOR);
        assert (i < 0) : "i should be negative, since index should no longer be selected";
        int n = this.selectedRanges.getLength();
        for (i = -(i + 1); i < n; ++i) {
            Span selectedRange = (Span)this.selectedRanges.get(i);
            this.selectedRanges.update(i, (Object)new Span(selectedRange.start - count, selectedRange.end - count));
            ++updated;
        }
        return updated;
    }

    public static Span normalize(int start, int end) {
        return new Span(Math.min(start, end), Math.max(start, end));
    }
}

