/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MovieViewListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.media.Movie;

@DefaultProperty(value="movie")
public class MovieView
extends Component {
    private Movie movie = null;
    private MovieViewListenerList movieViewListeners = new MovieViewListenerList();

    public MovieView() {
        this(null);
    }

    public MovieView(Movie movie) {
        this.setMovie(movie);
        this.installSkin(MovieView.class);
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        Movie previousMovie = this.movie;
        if (previousMovie != movie) {
            this.movie = movie;
            this.movieViewListeners.movieChanged(this, previousMovie);
        }
    }

    public ListenerList<MovieViewListener> getMovieViewListeners() {
        return this.movieViewListeners;
    }

    private static class MovieViewListenerList
    extends WTKListenerList<MovieViewListener>
    implements MovieViewListener {
        private MovieViewListenerList() {
        }

        @Override
        public void movieChanged(MovieView movieView, Movie previousMovie) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieViewListener listener = (MovieViewListener)i$.next();
                listener.movieChanged(movieView, previousMovie);
            }
        }
    }
}

