/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ListButtonBindingListener;
import org.apache.pivot.wtk.ListButtonItemListener;
import org.apache.pivot.wtk.ListButtonListener;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ListButtonDataRenderer;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

@DefaultProperty(value="listData")
public class ListButton
extends Button {
    private List<?> listData;
    private ListView.ItemRenderer itemRenderer;
    private boolean repeatable = false;
    private int selectedIndex = -1;
    private Filter<?> disabledItemFilter = null;
    private int listSize = -1;
    private String listDataKey = null;
    private BindType listDataBindType = BindType.BOTH;
    private ListView.ListDataBindMapping listDataBindMapping = null;
    private String selectedItemKey = null;
    private BindType selectedItemBindType = BindType.BOTH;
    private ListView.ItemBindMapping selectedItemBindMapping = null;
    private ListListener<Object> listDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int index) {
            int previousSelectedIndex = ListButton.this.selectedIndex;
            if (index <= ListButton.this.selectedIndex) {
                ListButton.this.selectedIndex++;
            }
            ListButton.this.listButtonItemListeners.itemInserted(ListButton.this, index);
            if (ListButton.this.selectedIndex != previousSelectedIndex) {
                ListButton.this.listButtonSelectionListeners.selectedIndexChanged(ListButton.this, ListButton.this.selectedIndex);
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int count = items.getLength();
            int previousSelectedIndex = ListButton.this.selectedIndex;
            if (ListButton.this.selectedIndex >= index) {
                if (ListButton.this.selectedIndex < index + count) {
                    ListButton.this.selectedIndex = -1;
                } else {
                    ListButton.this.selectedIndex -= count;
                }
            }
            ListButton.this.listButtonItemListeners.itemsRemoved(ListButton.this, index, count);
            if (ListButton.this.selectedIndex != previousSelectedIndex) {
                ListButton.this.listButtonSelectionListeners.selectedIndexChanged(ListButton.this, ListButton.this.selectedIndex);
                if (ListButton.this.selectedIndex == -1) {
                    ListButton.this.listButtonSelectionListeners.selectedItemChanged(ListButton.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            ListButton.this.listButtonItemListeners.itemUpdated(ListButton.this, index);
        }

        public void listCleared(List<Object> list) {
            int previousSelectedIndex = ListButton.this.selectedIndex;
            ListButton.this.selectedIndex = -1;
            ListButton.this.listButtonItemListeners.itemsCleared(ListButton.this);
            if (previousSelectedIndex != ListButton.this.selectedIndex) {
                ListButton.this.listButtonSelectionListeners.selectedIndexChanged(ListButton.this, ListButton.this.selectedIndex);
                ListButton.this.listButtonSelectionListeners.selectedItemChanged(ListButton.this, ListButton.this.getSelectedItem());
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                int previousSelectedIndex = ListButton.this.selectedIndex;
                ListButton.this.selectedIndex = -1;
                ListButton.this.listButtonItemListeners.itemsSorted(ListButton.this);
                if (previousSelectedIndex != ListButton.this.selectedIndex) {
                    ListButton.this.listButtonSelectionListeners.selectedIndexChanged(ListButton.this, ListButton.this.selectedIndex);
                    ListButton.this.listButtonSelectionListeners.selectedItemChanged(ListButton.this, ListButton.this.getSelectedItem());
                }
            }
        }
    };
    private ListButtonListenerList listButtonListeners = new ListButtonListenerList();
    private ListButtonItemListenerList listButtonItemListeners = new ListButtonItemListenerList();
    private ListButtonSelectionListenerList listButtonSelectionListeners = new ListButtonSelectionListenerList();
    private ListButtonBindingListenerList listButtonBindingListeners = new ListButtonBindingListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ListButtonDataRenderer();
    private static final ListView.ItemRenderer DEFAULT_ITEM_RENDERER = new ListViewItemRenderer();

    public ListButton() {
        this((List<?>)new ArrayList());
    }

    public ListButton(Object buttonData) {
        this(buttonData, (List<?>)new ArrayList());
    }

    public ListButton(List<?> listData) {
        this(null, listData);
    }

    public ListButton(Object buttonData, List<?> listData) {
        super(buttonData);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.setItemRenderer(DEFAULT_ITEM_RENDERER);
        this.setListData(listData);
        this.installSkin(ListButton.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Window getListPopup() {
        return ((Skin)((Object)this.getSkin())).getListViewPopup();
    }

    @Override
    public void setToggleButton(boolean toggleButton) {
        throw new UnsupportedOperationException("List buttons cannot be toggle buttons.");
    }

    public List<?> getListData() {
        return this.listData;
    }

    public void setListData(List<?> listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        List<?> previousListData = this.listData;
        if (previousListData != listData) {
            int previousSelectedIndex = this.selectedIndex;
            if (previousListData != null) {
                this.selectedIndex = -1;
                previousListData.getListListeners().remove(this.listDataListener);
            }
            listData.getListListeners().add(this.listDataListener);
            this.listData = listData;
            this.listButtonListeners.listDataChanged(this, previousListData);
            if (this.selectedIndex != previousSelectedIndex) {
                this.listButtonSelectionListeners.selectedIndexChanged(this, this.selectedIndex);
                this.listButtonSelectionListeners.selectedItemChanged(this, null);
            }
        }
    }

    public final void setListData(String listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        try {
            this.setListData(JSONSerializer.parseList((String)listData));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public void setListData(URL listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        JSONSerializer jsonSerializer = new JSONSerializer();
        try {
            this.setListData((List)jsonSerializer.readObject(listData.openStream()));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public ListView.ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ListView.ItemRenderer itemRenderer) {
        ListView.ItemRenderer previousItemRenderer = this.itemRenderer;
        if (previousItemRenderer != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.listButtonListeners.itemRendererChanged(this, previousItemRenderer);
        }
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean repeatable) {
        if (this.repeatable != repeatable) {
            this.repeatable = repeatable;
            this.listButtonListeners.repeatableChanged(this);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        ListButton.indexBoundsCheck("selectedIndex", selectedIndex, -1, this.listData.getLength() - 1);
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            this.selectedIndex = selectedIndex;
            this.listButtonSelectionListeners.selectedIndexChanged(this, previousSelectedIndex);
            this.listButtonSelectionListeners.selectedItemChanged(this, previousSelectedIndex == -1 ? null : this.listData.get(previousSelectedIndex));
        }
    }

    public Object getSelectedItem() {
        int index = this.getSelectedIndex();
        Object item = null;
        if (index >= 0) {
            item = this.listData.get(index);
        }
        return item;
    }

    public void setSelectedItem(Object item) {
        this.setSelectedIndex(item == null ? -1 : this.listData.indexOf(item));
    }

    public boolean isItemDisabled(int index) {
        boolean disabled = false;
        if (this.disabledItemFilter != null) {
            Object item = this.listData.get(index);
            disabled = this.disabledItemFilter.include(item);
        }
        return disabled;
    }

    public Filter<?> getDisabledItemFilter() {
        return this.disabledItemFilter;
    }

    public void setDisabledItemFilter(Filter<?> disabledItemFilter) {
        Filter<?> previousDisabledItemFilter = this.disabledItemFilter;
        if (previousDisabledItemFilter != disabledItemFilter) {
            this.disabledItemFilter = disabledItemFilter;
            this.listButtonListeners.disabledItemFilterChanged(this, previousDisabledItemFilter);
        }
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        if (listSize < -1) {
            throw new IllegalArgumentException("Invalid list size.");
        }
        int previousListSize = this.listSize;
        if (previousListSize != listSize) {
            this.listSize = listSize;
            this.listButtonListeners.listSizeChanged(this, previousListSize);
        }
    }

    public String getListDataKey() {
        return this.listDataKey;
    }

    public void setListDataKey(String listDataKey) {
        String previousListDataKey = this.listDataKey;
        if (previousListDataKey != listDataKey) {
            this.listDataKey = listDataKey;
            this.listButtonBindingListeners.listDataKeyChanged(this, previousListDataKey);
        }
    }

    public BindType getListDataBindType() {
        return this.listDataBindType;
    }

    public void setListDataBindType(BindType listDataBindType) {
        if (listDataBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousListDataBindType = this.listDataBindType;
        if (previousListDataBindType != listDataBindType) {
            this.listDataBindType = listDataBindType;
            this.listButtonBindingListeners.listDataBindTypeChanged(this, previousListDataBindType);
        }
    }

    public ListView.ListDataBindMapping getListDataBindMapping() {
        return this.listDataBindMapping;
    }

    public void setListDataBindMapping(ListView.ListDataBindMapping listDataBindMapping) {
        ListView.ListDataBindMapping previousListDataBindMapping = this.listDataBindMapping;
        if (previousListDataBindMapping != listDataBindMapping) {
            this.listDataBindMapping = listDataBindMapping;
            this.listButtonBindingListeners.listDataBindMappingChanged(this, previousListDataBindMapping);
        }
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String selectedItemKey) {
        String previousSelectedItemKey = this.selectedItemKey;
        if (previousSelectedItemKey != selectedItemKey) {
            this.selectedItemKey = selectedItemKey;
            this.listButtonBindingListeners.selectedItemKeyChanged(this, previousSelectedItemKey);
        }
    }

    public BindType getSelectedItemBindType() {
        return this.selectedItemBindType;
    }

    public void setSelectedItemBindType(BindType selectedItemBindType) {
        if (selectedItemBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedItemBindType = this.selectedItemBindType;
        if (previousSelectedItemBindType != selectedItemBindType) {
            this.selectedItemBindType = selectedItemBindType;
            this.listButtonBindingListeners.selectedItemBindTypeChanged(this, previousSelectedItemBindType);
        }
    }

    public ListView.ItemBindMapping getSelectedItemBindMapping() {
        return this.selectedItemBindMapping;
    }

    public void setSelectedItemBindMapping(ListView.ItemBindMapping selectedItemBindMapping) {
        ListView.ItemBindMapping previousSelectedItemBindMapping = this.selectedItemBindMapping;
        if (previousSelectedItemBindMapping != selectedItemBindMapping) {
            this.selectedItemBindMapping = selectedItemBindMapping;
            this.listButtonBindingListeners.selectedItemBindMappingChanged(this, previousSelectedItemBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.listDataKey != null && this.listDataBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.listDataKey)) {
            Object value = JSON.get((Object)context, (String)this.listDataKey);
            List<?> listDataLocal = this.listDataBindMapping == null ? (List<?>)value : this.listDataBindMapping.toListData(value);
            this.setListData(listDataLocal);
        }
        if (this.selectedItemKey != null && this.selectedItemBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.selectedItemKey)) {
            Object item = JSON.get((Object)context, (String)this.selectedItemKey);
            int index = this.selectedItemBindMapping == null ? this.listData.indexOf(item) : this.selectedItemBindMapping.indexOf(this.listData, item);
            this.setSelectedIndex(index);
        }
    }

    @Override
    public void store(Object context) {
        if (this.listDataKey != null && this.listDataBindType != BindType.LOAD) {
            Object value = this.listDataBindMapping == null ? this.listData : this.listDataBindMapping.valueOf(this.listData);
            JSON.put((Object)context, (String)this.listDataKey, value);
        }
        if (this.selectedItemKey != null && this.selectedItemBindType != BindType.LOAD) {
            int selectedIndexLocal = this.getSelectedIndex();
            Object item = this.selectedItemBindMapping == null ? (selectedIndexLocal == -1 ? null : this.listData.get(selectedIndexLocal)) : this.selectedItemBindMapping.get(this.listData, selectedIndexLocal);
            JSON.put((Object)context, (String)this.selectedItemKey, (Object)item);
        }
    }

    @Override
    public void clear() {
        if (this.listDataKey != null) {
            this.setListData((List<?>)new ArrayList());
        }
        if (this.selectedItemKey != null) {
            this.setSelectedItem(null);
        }
    }

    public void clearSelection() {
        this.setSelectedItem(null);
    }

    public ListenerList<ListButtonListener> getListButtonListeners() {
        return this.listButtonListeners;
    }

    public ListenerList<ListButtonItemListener> getListButtonItemListeners() {
        return this.listButtonItemListeners;
    }

    public ListenerList<ListButtonSelectionListener> getListButtonSelectionListeners() {
        return this.listButtonSelectionListeners;
    }

    public ListenerList<ListButtonBindingListener> getListButtonBindingListeners() {
        return this.listButtonBindingListeners;
    }

    public static interface Skin {
        public Window getListViewPopup();
    }

    private static class ListButtonBindingListenerList
    extends WTKListenerList<ListButtonBindingListener>
    implements ListButtonBindingListener {
        private ListButtonBindingListenerList() {
        }

        @Override
        public void listDataKeyChanged(ListButton listButton, String previousListDataKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.listDataKeyChanged(listButton, previousListDataKey);
            }
        }

        @Override
        public void listDataBindTypeChanged(ListButton listButton, BindType previousListDataBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.listDataBindTypeChanged(listButton, previousListDataBindType);
            }
        }

        @Override
        public void listDataBindMappingChanged(ListButton listButton, ListView.ListDataBindMapping previousListDataBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.listDataBindMappingChanged(listButton, previousListDataBindMapping);
            }
        }

        @Override
        public void selectedItemKeyChanged(ListButton listButton, String previousSelectedItemKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.selectedItemKeyChanged(listButton, previousSelectedItemKey);
            }
        }

        @Override
        public void selectedItemBindTypeChanged(ListButton listButton, BindType previousSelectedItemBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.selectedItemBindTypeChanged(listButton, previousSelectedItemBindType);
            }
        }

        @Override
        public void selectedItemBindMappingChanged(ListButton listButton, ListView.ItemBindMapping previousSelectedItemBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonBindingListener listener = (ListButtonBindingListener)i$.next();
                listener.selectedItemBindMappingChanged(listButton, previousSelectedItemBindMapping);
            }
        }
    }

    private static class ListButtonSelectionListenerList
    extends WTKListenerList<ListButtonSelectionListener>
    implements ListButtonSelectionListener {
        private ListButtonSelectionListenerList() {
        }

        @Override
        public void selectedIndexChanged(ListButton listButton, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonSelectionListener listener = (ListButtonSelectionListener)i$.next();
                listener.selectedIndexChanged(listButton, previousSelectedIndex);
            }
        }

        @Override
        public void selectedItemChanged(ListButton listButton, Object previousSelectedItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonSelectionListener listener = (ListButtonSelectionListener)i$.next();
                listener.selectedItemChanged(listButton, previousSelectedItem);
            }
        }
    }

    private static class ListButtonItemListenerList
    extends WTKListenerList<ListButtonItemListener>
    implements ListButtonItemListener {
        private ListButtonItemListenerList() {
        }

        @Override
        public void itemInserted(ListButton listButton, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonItemListener listener = (ListButtonItemListener)i$.next();
                listener.itemInserted(listButton, index);
            }
        }

        @Override
        public void itemsRemoved(ListButton listButton, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonItemListener listener = (ListButtonItemListener)i$.next();
                listener.itemsRemoved(listButton, index, count);
            }
        }

        @Override
        public void itemUpdated(ListButton listButton, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonItemListener listener = (ListButtonItemListener)i$.next();
                listener.itemUpdated(listButton, index);
            }
        }

        @Override
        public void itemsCleared(ListButton listButton) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonItemListener listener = (ListButtonItemListener)i$.next();
                listener.itemsCleared(listButton);
            }
        }

        @Override
        public void itemsSorted(ListButton listButton) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonItemListener listener = (ListButtonItemListener)i$.next();
                listener.itemsSorted(listButton);
            }
        }
    }

    private static class ListButtonListenerList
    extends WTKListenerList<ListButtonListener>
    implements ListButtonListener {
        private ListButtonListenerList() {
        }

        @Override
        public void listDataChanged(ListButton listButton, List<?> previousListData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonListener listener = (ListButtonListener)i$.next();
                listener.listDataChanged(listButton, previousListData);
            }
        }

        @Override
        public void itemRendererChanged(ListButton listButton, ListView.ItemRenderer previousItemRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonListener listener = (ListButtonListener)i$.next();
                listener.itemRendererChanged(listButton, previousItemRenderer);
            }
        }

        @Override
        public void repeatableChanged(ListButton listButton) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonListener listener = (ListButtonListener)i$.next();
                listener.repeatableChanged(listButton);
            }
        }

        @Override
        public void disabledItemFilterChanged(ListButton listButton, Filter<?> previousDisabledItemFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonListener listener = (ListButtonListener)i$.next();
                listener.disabledItemFilterChanged(listButton, previousDisabledItemFilter);
            }
        }

        @Override
        public void listSizeChanged(ListButton listButton, int previousListSize) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListButtonListener listener = (ListButtonListener)i$.next();
                listener.listSizeChanged(listButton, previousListSize);
            }
        }
    }
}

