/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.LabelBindingListener;
import org.apache.pivot.wtk.LabelListener;
import org.apache.pivot.wtk.WTKListenerList;

public class Label
extends Component {
    private String text = null;
    private int maximumLength = Short.MAX_VALUE;
    private String textKey = null;
    private BindType textBindType = BindType.BOTH;
    private TextBindMapping textBindMapping = null;
    private LabelListenerList labelListeners = new LabelListenerList();
    private LabelBindingListenerList labelBindingListeners = new LabelBindingListenerList();

    public Label() {
        this("");
    }

    public Label(String text) {
        this.setText(text);
        this.installSkin(Label.class);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (text.length() > this.maximumLength) {
            throw new IllegalArgumentException("Text length is greater than maximum length.");
        }
        String previousText = this.text;
        if (previousText != text) {
            this.text = text;
            this.labelListeners.textChanged(this, previousText);
        }
    }

    public void setTextOrEmpty(String text) {
        this.setText(text != null ? text : "");
    }

    public String getTextKey() {
        return this.textKey;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        if (maximumLength < 0) {
            throw new IllegalArgumentException("maximumLength is negative.");
        }
        int previousMaximumLength = this.maximumLength;
        if (previousMaximumLength != maximumLength) {
            this.maximumLength = maximumLength;
            if (this.text.length() > maximumLength) {
                this.setText(this.text.substring(0, maximumLength));
            }
            this.labelListeners.maximumLengthChanged(this, previousMaximumLength);
        }
    }

    public void setTextKey(String textKey) {
        String previousTextKey = this.textKey;
        if (previousTextKey != textKey) {
            this.textKey = textKey;
            this.labelBindingListeners.textKeyChanged(this, previousTextKey);
        }
    }

    public BindType getTextBindType() {
        return this.textBindType;
    }

    public void setTextBindType(BindType textBindType) {
        if (textBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousTextBindType = this.textBindType;
        if (previousTextBindType != textBindType) {
            this.textBindType = textBindType;
            this.labelBindingListeners.textBindTypeChanged(this, previousTextBindType);
        }
    }

    public TextBindMapping getTextBindMapping() {
        return this.textBindMapping;
    }

    public void setTextBindMapping(TextBindMapping textBindMapping) {
        TextBindMapping previousTextBindMapping = this.textBindMapping;
        if (previousTextBindMapping != textBindMapping) {
            this.textBindMapping = textBindMapping;
            this.labelBindingListeners.textBindMappingChanged(this, previousTextBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.textKey != null && JSON.containsKey((Object)context, (String)this.textKey) && this.textBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.textKey);
            value = this.textBindMapping == null ? (value == null ? null : value.toString()) : this.textBindMapping.toString(value);
            this.setText(value != null ? (String)value : "");
        }
    }

    @Override
    public void store(Object context) {
        if (this.textKey != null && this.textBindType != BindType.LOAD) {
            String textLocal = this.getText();
            JSON.put((Object)context, (String)this.textKey, (Object)(this.textBindMapping == null ? textLocal : this.textBindMapping.valueOf(textLocal)));
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText("");
        }
    }

    public ListenerList<LabelListener> getLabelListeners() {
        return this.labelListeners;
    }

    public ListenerList<LabelBindingListener> getLabelBindingListeners() {
        return this.labelBindingListeners;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [\"" + this.getText() + "\"]";
    }

    private static class LabelBindingListenerList
    extends WTKListenerList<LabelBindingListener>
    implements LabelBindingListener {
        private LabelBindingListenerList() {
        }

        @Override
        public void textKeyChanged(Label label, String previousTextKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                LabelBindingListener listener = (LabelBindingListener)i$.next();
                listener.textKeyChanged(label, previousTextKey);
            }
        }

        @Override
        public void textBindTypeChanged(Label label, BindType previousTextBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                LabelBindingListener listener = (LabelBindingListener)i$.next();
                listener.textBindTypeChanged(label, previousTextBindType);
            }
        }

        @Override
        public void textBindMappingChanged(Label label, TextBindMapping previousTextBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                LabelBindingListener listener = (LabelBindingListener)i$.next();
                listener.textBindMappingChanged(label, previousTextBindMapping);
            }
        }
    }

    private static class LabelListenerList
    extends WTKListenerList<LabelListener>
    implements LabelListener {
        private LabelListenerList() {
        }

        @Override
        public void textChanged(Label label, String previousText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                LabelListener listener = (LabelListener)i$.next();
                listener.textChanged(label, previousText);
            }
        }

        @Override
        public void maximumLengthChanged(Label label, int previousMaximumLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                LabelListener listener = (LabelListener)i$.next();
                listener.maximumLengthChanged(label, previousMaximumLength);
            }
        }
    }

    public static interface TextBindMapping {
        public String toString(Object var1);

        public Object valueOf(String var1);
    }
}

