/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Orientation;

public final class GraphicsUtilities {
    public static final String PAINT_TYPE_KEY = "paintType";
    public static final String COLOR_KEY = "color";
    public static final String START_X_KEY = "startX";
    public static final String START_Y_KEY = "startY";
    public static final String END_X_KEY = "endX";
    public static final String END_Y_KEY = "endY";
    public static final String START_COLOR_KEY = "startColor";
    public static final String END_COLOR_KEY = "endColor";
    public static final String CENTER_X_KEY = "centerX";
    public static final String CENTER_Y_KEY = "centerY";
    public static final String RADIUS_KEY = "radius";
    public static final String STOPS_KEY = "stops";
    public static final String OFFSET_KEY = "offset";

    private GraphicsUtilities() {
    }

    public static final void drawLine(Graphics2D graphics, int x, int y, int length, Orientation orientation) {
        GraphicsUtilities.drawLine(graphics, x, y, length, orientation, 1);
    }

    public static final void drawLine(Graphics2D graphics, int x, int y, int length, Orientation orientation, int thickness) {
        if (length > 0 && thickness > 0) {
            switch (orientation) {
                case HORIZONTAL: {
                    graphics.fillRect(x, y, length, thickness);
                    break;
                }
                case VERTICAL: {
                    graphics.fillRect(x, y, thickness, length);
                    break;
                }
            }
        }
    }

    public static final void drawRect(Graphics2D graphics, int x, int y, int width, int height) {
        GraphicsUtilities.drawRect(graphics, x, y, width, height, 1);
    }

    public static final void drawRect(Graphics2D graphics, int x, int y, int width, int height, int thickness) {
        Graphics2D rectGraphics = graphics;
        if ((graphics.getTransform().getType() & 6) != 0) {
            rectGraphics = (Graphics2D)graphics.create();
            rectGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (width > 0 && height > 0 && thickness > 0) {
            GraphicsUtilities.drawLine(rectGraphics, x, y, width, Orientation.HORIZONTAL, thickness);
            GraphicsUtilities.drawLine(rectGraphics, x + width - thickness, y, height, Orientation.VERTICAL, thickness);
            GraphicsUtilities.drawLine(rectGraphics, x, y + height - thickness, width, Orientation.HORIZONTAL, thickness);
            GraphicsUtilities.drawLine(rectGraphics, x, y, height, Orientation.VERTICAL, thickness);
        }
        if (rectGraphics != graphics) {
            rectGraphics.dispose();
        }
    }

    public static Color decodeColor(String value) throws NumberFormatException {
        Color color;
        if (value == null) {
            throw new IllegalArgumentException("Cannot decode a null String.");
        }
        String valueLowercase = value.toLowerCase(Locale.ENGLISH);
        if (valueLowercase.startsWith("0x")) {
            if ((valueLowercase = valueLowercase.substring(2)).length() != 8) {
                throw new IllegalArgumentException("Incorrect Color format.  Expecting exactly 8 digits after the '0x' prefix.");
            }
            int rgb = Integer.parseInt(valueLowercase.substring(0, 6), 16);
            float alpha = (float)Integer.parseInt(valueLowercase.substring(6, 8), 16) / 255.0f;
            color = GraphicsUtilities.getColor(rgb, alpha);
        } else if (valueLowercase.startsWith("#")) {
            if ((valueLowercase = valueLowercase.substring(1)).length() != 6) {
                throw new IllegalArgumentException("Incorrect Color format.  Expecting exactly 6 digits after the '#' prefix.");
            }
            int rgb = Integer.parseInt(valueLowercase, 16);
            float alpha = 1.0f;
            color = GraphicsUtilities.getColor(rgb, alpha);
        } else {
            try {
                color = (Color)Color.class.getDeclaredField(valueLowercase).get(null);
            }
            catch (Exception exception) {
                if (valueLowercase.equals("darkgray") || valueLowercase.equals("darkgrey")) {
                    color = Color.darkGray;
                }
                if (valueLowercase.equals("lightgray") || valueLowercase.equals("lightgrey")) {
                    color = Color.lightGray;
                }
                if (valueLowercase.equals("grey")) {
                    color = Color.gray;
                }
                throw new IllegalArgumentException("\"" + valueLowercase + "\" is not a valid color constant.");
            }
        }
        return color;
    }

    public static Color getColor(int rgb, float alpha) {
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb >> 0 & 0xFF) / 255.0f;
        return new Color(red, green, blue, alpha);
    }

    public static Paint decodePaint(String value) {
        Paint paint;
        if (value == null) {
            throw new IllegalArgumentException("Cannot decode a null String.");
        }
        if (value.startsWith("#") || value.startsWith("0x") || value.startsWith("0X")) {
            paint = GraphicsUtilities.decodeColor(value);
        } else {
            try {
                paint = GraphicsUtilities.decodePaint(JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        return paint;
    }

    public static Paint decodePaint(Dictionary<String, ?> dictionary) {
        Paint paint;
        String paintType = (String)JSON.get(dictionary, (String)PAINT_TYPE_KEY);
        if (paintType == null) {
            throw new IllegalArgumentException("paintType is required.");
        }
        switch (PaintType.valueOf(paintType.toUpperCase(Locale.ENGLISH))) {
            case SOLID_COLOR: {
                String color = (String)JSON.get(dictionary, (String)COLOR_KEY);
                paint = GraphicsUtilities.decodeColor(color);
                break;
            }
            case GRADIENT: {
                float startX = JSON.getFloat(dictionary, (String)START_X_KEY);
                float startY = JSON.getFloat(dictionary, (String)START_Y_KEY);
                float endX = JSON.getFloat(dictionary, (String)END_X_KEY);
                float endY = JSON.getFloat(dictionary, (String)END_Y_KEY);
                Color startColor = GraphicsUtilities.decodeColor((String)JSON.get(dictionary, (String)START_COLOR_KEY));
                Color endColor = GraphicsUtilities.decodeColor((String)JSON.get(dictionary, (String)END_COLOR_KEY));
                paint = new GradientPaint(startX, startY, startColor, endX, endY, endColor);
                break;
            }
            case LINEAR_GRADIENT: {
                float startX = JSON.getFloat(dictionary, (String)START_X_KEY);
                float startY = JSON.getFloat(dictionary, (String)START_Y_KEY);
                float endX = JSON.getFloat(dictionary, (String)END_X_KEY);
                float endY = JSON.getFloat(dictionary, (String)END_Y_KEY);
                List stops = (List)JSON.get(dictionary, (String)STOPS_KEY);
                int n = stops.getLength();
                float[] fractions = new float[n];
                Color[] colors = new Color[n];
                for (int i = 0; i < n; ++i) {
                    Color color;
                    float offset;
                    Dictionary stop = (Dictionary)stops.get(i);
                    fractions[i] = offset = JSON.getFloat((Object)stop, (String)OFFSET_KEY);
                    colors[i] = color = GraphicsUtilities.decodeColor((String)JSON.get((Object)stop, (String)COLOR_KEY));
                }
                paint = new LinearGradientPaint(startX, startY, endX, endY, fractions, colors);
                break;
            }
            case RADIAL_GRADIENT: {
                float centerX = JSON.getFloat(dictionary, (String)CENTER_X_KEY);
                float centerY = JSON.getFloat(dictionary, (String)CENTER_Y_KEY);
                float radius = JSON.getFloat(dictionary, (String)RADIUS_KEY);
                List stops = (List)JSON.get(dictionary, (String)STOPS_KEY);
                int n = stops.getLength();
                float[] fractions = new float[n];
                Color[] colors = new Color[n];
                for (int i = 0; i < n; ++i) {
                    Color color;
                    float offset;
                    Dictionary stop = (Dictionary)stops.get(i);
                    fractions[i] = offset = JSON.getFloat((Object)stop, (String)OFFSET_KEY);
                    colors[i] = color = GraphicsUtilities.decodeColor((String)JSON.get((Object)stop, (String)COLOR_KEY));
                }
                paint = new RadialGradientPaint(centerX, centerY, radius, fractions, colors);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return paint;
    }

    public static enum PaintType {
        SOLID_COLOR,
        GRADIENT,
        LINEAR_GRADIENT,
        RADIAL_GRADIENT;

    }
}

