/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FillPaneListener;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.WTKListenerList;

public class FillPane
extends Container {
    private Orientation orientation = null;
    private FillPaneListenerList fillPaneListeners = new FillPaneListenerList();

    public FillPane() {
        this(Orientation.HORIZONTAL);
    }

    public FillPane(Orientation orientation) {
        this.setOrientation(orientation);
        this.installSkin(FillPane.class);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException();
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.fillPaneListeners.orientationChanged(this);
        }
    }

    public ListenerList<FillPaneListener> getFillPaneListeners() {
        return this.fillPaneListeners;
    }

    private static class FillPaneListenerList
    extends WTKListenerList<FillPaneListener>
    implements FillPaneListener {
        private FillPaneListenerList() {
        }

        @Override
        public void orientationChanged(FillPane fillPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FillPaneListener listener = (FillPaneListener)i$.next();
                listener.orientationChanged(fillPane);
            }
        }
    }
}

