/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.File;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FileBrowserListener;
import org.apache.pivot.wtk.WTKListenerList;

public class FileBrowser
extends Container {
    private static final String USER_HOME = System.getProperty("user.home");
    private File rootDirectory;
    private FileList selectedFiles = new FileList();
    private boolean multiSelect = false;
    private Filter<File> disabledFileFilter = null;
    private FileBrowserListenerList fileBrowserListeners = new FileBrowserListenerList();

    public FileBrowser() {
        this(USER_HOME);
    }

    public FileBrowser(String rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException();
        }
        this.rootDirectory = new File(rootFolder);
        if (!this.rootDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.installSkin(FileBrowser.class);
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        if (rootDirectory == null || !rootDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (rootDirectory.exists()) {
            File previousRootDirectory = this.rootDirectory;
            if (!rootDirectory.equals(previousRootDirectory)) {
                this.rootDirectory = rootDirectory;
                this.selectedFiles.clear();
                this.fileBrowserListeners.rootDirectoryChanged(this, previousRootDirectory);
            }
        } else {
            this.setRootDirectory(rootDirectory.getParentFile());
        }
    }

    public boolean addSelectedFile(File file) {
        int index;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        File fileMutable = file;
        if (fileMutable.isAbsolute()) {
            if (!fileMutable.getParentFile().equals(this.rootDirectory)) {
                throw new IllegalArgumentException();
            }
        } else {
            fileMutable = new File(this.rootDirectory, fileMutable.getPath());
        }
        if ((index = this.selectedFiles.add(fileMutable)) != -1) {
            this.fileBrowserListeners.selectedFileAdded(this, fileMutable);
        }
        return index != -1;
    }

    public boolean removeSelectedFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        int index = this.selectedFiles.remove((Object)file);
        if (index != -1) {
            this.fileBrowserListeners.selectedFileRemoved(this, file);
        }
        return index != -1;
    }

    public File getSelectedFile() {
        if (this.multiSelect) {
            throw new IllegalStateException("File browser is not in single-select mode.");
        }
        return this.selectedFiles.getLength() == 0 ? null : (File)this.selectedFiles.get(0);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.clearSelection();
        } else {
            if (file.isAbsolute()) {
                this.setRootDirectory(file.getParentFile());
            }
            this.setSelectedFiles((Sequence<File>)new ArrayList((Object[])new File[]{file}));
        }
    }

    public ImmutableList<File> getSelectedFiles() {
        return new ImmutableList((List)this.selectedFiles);
    }

    public Sequence<File> setSelectedFiles(Sequence<File> selectedFiles) {
        if (selectedFiles == null) {
            throw new IllegalArgumentException("selectedFiles is null.");
        }
        if (!this.multiSelect && selectedFiles.getLength() > 1) {
            throw new IllegalArgumentException("Multi-select is not enabled.");
        }
        ImmutableList<File> previousSelectedFiles = this.getSelectedFiles();
        FileList fileList = new FileList();
        int n = selectedFiles.getLength();
        for (int i = 0; i < n; ++i) {
            File file = (File)selectedFiles.get(i);
            if (file == null) {
                throw new IllegalArgumentException("file is null.");
            }
            if (!file.isAbsolute()) {
                file = new File(this.rootDirectory, file.getPath());
            }
            if (!file.getParentFile().equals(this.rootDirectory)) {
                throw new IllegalArgumentException();
            }
            fileList.add(file);
        }
        this.selectedFiles = fileList;
        this.fileBrowserListeners.selectedFilesChanged(this, (Sequence<File>)previousSelectedFiles);
        return this.getSelectedFiles();
    }

    public void clearSelection() {
        this.setSelectedFiles((Sequence<File>)new ArrayList());
    }

    public boolean isFileSelected(File file) {
        return this.selectedFiles.indexOf((Object)file) != -1;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (this.multiSelect != multiSelect) {
            this.selectedFiles.clear();
            this.multiSelect = multiSelect;
            this.fileBrowserListeners.multiSelectChanged(this);
        }
    }

    public Filter<File> getDisabledFileFilter() {
        return this.disabledFileFilter;
    }

    public void setDisabledFileFilter(Filter<File> disabledFileFilter) {
        Filter<File> previousDisabledFileFilter = this.disabledFileFilter;
        if (previousDisabledFileFilter != disabledFileFilter) {
            this.disabledFileFilter = disabledFileFilter;
            this.fileBrowserListeners.disabledFileFilterChanged(this, previousDisabledFileFilter);
        }
    }

    public File getFileAt(int x, int y) {
        Skin fileBrowserSkin = (Skin)this.getSkin();
        return fileBrowserSkin.getFileAt(x, y);
    }

    public ListenerList<FileBrowserListener> getFileBrowserListeners() {
        return this.fileBrowserListeners;
    }

    private static class FileBrowserListenerList
    extends WTKListenerList<FileBrowserListener>
    implements FileBrowserListener {
        private FileBrowserListenerList() {
        }

        @Override
        public void rootDirectoryChanged(FileBrowser fileBrowser, File previousRootDirectory) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.rootDirectoryChanged(fileBrowser, previousRootDirectory);
            }
        }

        @Override
        public void selectedFileAdded(FileBrowser fileBrowser, File file) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.selectedFileAdded(fileBrowser, file);
            }
        }

        @Override
        public void selectedFileRemoved(FileBrowser fileBrowser, File file) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.selectedFileRemoved(fileBrowser, file);
            }
        }

        @Override
        public void selectedFilesChanged(FileBrowser fileBrowser, Sequence<File> previousSelectedFiles) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.selectedFilesChanged(fileBrowser, previousSelectedFiles);
            }
        }

        @Override
        public void multiSelectChanged(FileBrowser fileBrowser) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.multiSelectChanged(fileBrowser);
            }
        }

        @Override
        public void disabledFileFilterChanged(FileBrowser fileBrowser, Filter<File> previousDisabledFileFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FileBrowserListener listener = (FileBrowserListener)i$.next();
                listener.disabledFileFilterChanged(fileBrowser, previousDisabledFileFilter);
            }
        }
    }

    public static interface Skin
    extends org.apache.pivot.wtk.Skin {
        public File getFileAt(int var1, int var2);
    }
}

