/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.content.ButtonDataRenderer;

@DefaultProperty(value="buttonData")
public class Checkbox
extends Button {
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer();

    public Checkbox() {
        this(null);
    }

    public Checkbox(Object buttonData) {
        super(buttonData);
        super.setToggleButton(true);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installSkin(Checkbox.class);
    }

    @Override
    public void press() {
        Button.State state = this.getState();
        if (state == Button.State.SELECTED) {
            this.setState(Button.State.UNSELECTED);
        } else if (state == Button.State.UNSELECTED) {
            this.setState(this.isTriState() ? Button.State.MIXED : Button.State.SELECTED);
        } else {
            this.setState(Button.State.SELECTED);
        }
        super.press();
    }

    @Override
    public void setToggleButton(boolean toggleButton) {
        throw new UnsupportedOperationException("Checkboxes are always toggle buttons.");
    }

    @Override
    public void setButtonGroup(ButtonGroup buttonGroup) {
        throw new UnsupportedOperationException("Checkboxes can't be added to a group.");
    }

    static {
        DEFAULT_DATA_RENDERER.getStyles().put((Object)"horizontalAlignment", (Object)HorizontalAlignment.LEFT);
    }
}

