/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.AbstractActionManager;
import org.apache.pdfbox.preflight.action.GoToAction;
import org.apache.pdfbox.preflight.action.GoToRemoteAction;
import org.apache.pdfbox.preflight.action.HideAction;
import org.apache.pdfbox.preflight.action.InvalidAction;
import org.apache.pdfbox.preflight.action.NamedAction;
import org.apache.pdfbox.preflight.action.SubmitAction;
import org.apache.pdfbox.preflight.action.ThreadAction;
import org.apache.pdfbox.preflight.action.UndefAction;
import org.apache.pdfbox.preflight.action.UriAction;
import org.apache.pdfbox.preflight.exception.ValidationException;

public class ActionManagerFactory {
    public final List<AbstractActionManager> getActionManagers(PreflightContext ctx, COSDictionary dictionary) throws ValidationException {
        COSDictionary aaDict;
        COSBase oaDict;
        ArrayList<AbstractActionManager> result = new ArrayList<AbstractActionManager>(0);
        HashMap<COSObjectKey, Boolean> alreadyCreated = new HashMap<COSObjectKey, Boolean>();
        COSBase aDict = dictionary.getDictionaryObject(COSName.A);
        if (aDict != null) {
            this.callCreateAction(aDict, ctx, result, alreadyCreated);
        }
        if ((oaDict = dictionary.getDictionaryObject(COSName.OPEN_ACTION)) != null && !(oaDict instanceof COSArray)) {
            this.callCreateAction(oaDict, ctx, result, alreadyCreated);
        }
        if ((aaDict = dictionary.getCOSDictionary(COSName.AA)) != null) {
            for (COSName name : aaDict.keySet()) {
                this.callCreateAction(aaDict.getDictionaryObject(name), ctx, result, name.getName(), alreadyCreated);
            }
        }
        return result;
    }

    private void callCreateAction(COSBase aDict, PreflightContext ctx, List<AbstractActionManager> result, Map<COSObjectKey, Boolean> alreadyCreated) throws ValidationException {
        this.callCreateAction(aDict, ctx, result, null, alreadyCreated);
    }

    private void callCreateAction(COSBase aDict, PreflightContext ctx, List<AbstractActionManager> result, String additionActionKey, Map<COSObjectKey, Boolean> alreadyCreated) throws ValidationException {
        if (aDict instanceof COSDictionary || aDict instanceof COSObject && ((COSObject)aDict).getObject() instanceof COSDictionary) {
            if (aDict instanceof COSObject) {
                COSObject cosObj = (COSObject)aDict;
                COSObjectKey cok = new COSObjectKey(cosObj.getObjectNumber(), cosObj.getGenerationNumber());
                COSDictionary indirectDict = (COSDictionary)cosObj.getObject();
                if (!alreadyCreated.containsKey(cok)) {
                    result.add(this.createActionManager(ctx, indirectDict, additionActionKey));
                    alreadyCreated.put(cok, true);
                }
            } else {
                result.add(this.createActionManager(ctx, (COSDictionary)aDict, additionActionKey));
            }
        } else {
            ctx.addValidationError(new ValidationResult.ValidationError("6.1.3", "Action entry isn't an instance of COSDictionary"));
        }
    }

    public final List<AbstractActionManager> getNextActions(PreflightContext ctx, COSDictionary actionDictionary) throws ValidationException {
        ArrayList<AbstractActionManager> result = new ArrayList<AbstractActionManager>(0);
        HashMap<COSObjectKey, Boolean> alreadyCreated = new HashMap<COSObjectKey, Boolean>();
        COSBase nextDict = actionDictionary.getDictionaryObject(COSName.NEXT);
        if (nextDict != null) {
            if (nextDict instanceof COSArray) {
                COSArray array = (COSArray)nextDict;
                for (int i = 0; i < array.size(); ++i) {
                    this.callCreateAction(array.getObject(i), ctx, result, alreadyCreated);
                }
            } else {
                this.callCreateAction(nextDict, ctx, result, alreadyCreated);
            }
        }
        return result;
    }

    protected AbstractActionManager createActionManager(PreflightContext ctx, COSDictionary action, String aaKey) throws ValidationException {
        String type = action.getNameAsString(COSName.TYPE);
        if (type != null && !"Action".equals(type)) {
            throw new ValidationException("The given dictionary isn't the dictionary of an Action");
        }
        String s = action.getNameAsString(COSName.S);
        if ("GoTo".equals(s)) {
            return new GoToAction(this, action, ctx, aaKey);
        }
        if ("GoToR".equals(s)) {
            return new GoToRemoteAction(this, action, ctx, aaKey);
        }
        if ("Thread".equals(s)) {
            return new ThreadAction(this, action, ctx, aaKey);
        }
        if ("URI".equals(s)) {
            return new UriAction(this, action, ctx, aaKey);
        }
        if ("Hide".equals(s)) {
            return new HideAction(this, action, ctx, aaKey);
        }
        if ("Named".equals(s)) {
            return new NamedAction(this, action, ctx, aaKey);
        }
        if ("SubmitForm".equals(s)) {
            return new SubmitAction(this, action, ctx, aaKey);
        }
        if ("Launch".equals(s) || "Sound".equals(s) || "Movie".equals(s) || "ResetForm".equals(s) || "ImportData".equals(s) || "JavaScript".equals(s) || "SetState".equals(s) || "NOP".equals(s)) {
            return new InvalidAction(this, action, ctx, aaKey, s);
        }
        return new UndefAction(this, action, ctx, aaKey, s);
    }
}

