/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class CatalogValidationProcess
extends AbstractProcess {
    private static final List<String> listICC = Arrays.asList("FOGRA43", "CGATS TR 006", "CGATS TR006", "FOGRA39", "JC200103", "FOGRA27", "EUROSB104", "FOGRA45", "FOGRA46", "FOGRA41", "CGATS TR 001", "CGATS TR001", "CGATS TR 003", "CGATS TR003", "CGATS TR 005", "CGATS TR005", "FOGRA28", "JCW2003", "EUROSB204", "FOGRA47", "FOGRA44", "FOGRA29", "JC200104", "FOGRA40", "FOGRA30", "FOGRA42", "IFRA26", "JCN2002", "CGATS TR 002", "CGATS TR002", "FOGRA33", "FOGRA37", "FOGRA31", "FOGRA35", "FOGRA32", "FOGRA34", "FOGRA36", "FOGRA38", "sRGB", "sRGB IEC61966-2.1", "Adobe RGB (1998)", "bg-sRGB", "sYCC", "scRGB", "scRGB-nl", "scYCC-nl", "ROMM RGB", "RIMM RGB", "ERIMM RGB", "eciRGB", "opRGB");
    private PDDocumentCatalog catalog;

    private boolean isStandardICCCharacterization(String name) {
        return listICC.stream().anyMatch(i -> i.contains(name));
    }

    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfbox = ctx.getDocument();
        this.catalog = pdfbox.getDocumentCatalog();
        if (this.catalog == null) {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document"));
        } else {
            this.validateActions(ctx);
            this.validateLang(ctx);
            this.validateNames(ctx);
            this.validateOCProperties(ctx);
            this.validateOutputIntent(ctx);
        }
    }

    private void validateActions(PreflightContext ctx) throws ValidationException {
        ContextHelper.validateElement(ctx, this.catalog.getCOSObject(), "actions-process");
        if (this.catalog.getCOSObject().containsKey(COSName.AA)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.2", "The AA field is forbidden for the Catalog  when the PDF is a PDF/A"));
        }
    }

    private void validateLang(PreflightContext ctx) {
        String lang = this.catalog.getLanguage();
        if (lang != null && !lang.isEmpty() && !lang.matches("[A-Za-z]{1,8}(-[A-Za-z]{1,8})*")) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.0.8"));
        }
    }

    private void validateNames(PreflightContext ctx) {
        PDDocumentNameDictionary names = this.catalog.getNames();
        if (names != null) {
            if (names.getEmbeddedFiles() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.7", "EmbeddedFile entry is present in the Names dictionary"));
            }
            if (names.getJavaScript() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.1", "Javascript entry is present in the Names dictionary"));
            }
        }
    }

    private void validateOCProperties(PreflightContext ctx) {
        if (this.catalog.getOCProperties() != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.8", "A Catalog shall not contain the OCPProperties entry"));
        }
    }

    private void validateOutputIntent(PreflightContext ctx) throws ValidationException {
        COSArray outputIntents = this.catalog.getCOSObject().getCOSArray(COSName.OUTPUT_INTENTS);
        HashMap<COSObjectKey, Boolean> tmpDestOutputProfile = new HashMap<COSObjectKey, Boolean>();
        if (outputIntents == null) {
            return;
        }
        for (int i = 0; i < outputIntents.size(); ++i) {
            String info;
            COSDictionary outputIntentDict = (COSDictionary)outputIntents.getObject(i);
            if (outputIntentDict == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "OutputIntent object is null or isn't a dictionary"));
                continue;
            }
            COSName sValue = outputIntentDict.getCOSName(COSName.S);
            if (!COSName.GTS_PDFA1.equals(sValue)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.3", "The S entry of the OutputIntent isn't GTS_PDFA1"));
                continue;
            }
            String outputConditionIdentifier = outputIntentDict.getString(COSName.OUTPUT_CONDITION_IDENTIFIER);
            if (outputConditionIdentifier == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "The OutputIntentCondition is missing"));
                continue;
            }
            COSBase destOutputProfile = outputIntentDict.getItem(COSName.DEST_OUTPUT_PROFILE);
            this.validateICCProfile(destOutputProfile, tmpDestOutputProfile, ctx);
            PreflightConfiguration config = ctx.getConfig();
            if (!config.isLazyValidation() || this.isStandardICCCharacterization(outputConditionIdentifier) || (info = outputIntentDict.getString(COSName.INFO)) != null && !info.isEmpty()) continue;
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.2", "The Info entry of a OutputIntent dictionary is missing");
            error.setWarning(true);
            this.addValidationError(ctx, error);
        }
    }

    private void validateICCProfile(COSBase destOutputProfile, Map<COSObjectKey, Boolean> mapDestOutputProfile, PreflightContext ctx) throws ValidationException {
        block19: {
            try {
                if (!(destOutputProfile instanceof COSObject)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "OutputIntent object should be a reference: " + destOutputProfile));
                    return;
                }
                COSObject cosObj = (COSObject)destOutputProfile;
                COSObjectKey key = new COSObjectKey(cosObj.getObjectNumber(), cosObj.getGenerationNumber());
                if (mapDestOutputProfile.containsKey(key)) {
                    return;
                }
                if (!mapDestOutputProfile.isEmpty()) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.5", "More than one ICCProfile is defined: " + destOutputProfile));
                    return;
                }
                mapDestOutputProfile.put(key, true);
                COSBase localDestOutputProfile = cosObj.getObject();
                if (!(localDestOutputProfile instanceof COSStream)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "OutputIntent object must be a stream"));
                    return;
                }
                COSStream stream = (COSStream)localDestOutputProfile;
                COSArray array = new COSArray();
                array.add(COSName.ICCBASED);
                array.add(stream);
                PDICCBased iccBased = PDICCBased.create(array, null);
                PreflightConfiguration cfg = ctx.getConfig();
                ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                ColorSpaceHelper csHelper = csFact.getColorSpaceHelper(ctx, iccBased, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
                csHelper.validate();
                if (ctx.getIccProfileWrapper() != null) break block19;
                try (COSInputStream is = stream.createInputStream();){
                    ctx.setIccProfileWrapper(new ICCProfileWrapper(ICC_Profile.getInstance(is)));
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.4", "DestOutputProfile isn't a valid ICCProfile: " + e.getMessage(), e));
            }
            catch (IOException e) {
                throw new ValidationException("Unable to parse the ICC Profile.", e);
            }
        }
    }
}

