/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(PDFParser.class);

    public PDFParser(RandomAccessRead source) throws IOException {
        this(source, "");
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword) throws IOException {
        this(source, decryptionPassword, null, null);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(source, decryptionPassword, keyStore, alias, null);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        super(source, decryptionPassword, keyStore, alias);
    }

    protected void initialParse() throws IOException {
        COSDictionary trailer = this.retrieveTrailer();
        COSDictionary root = trailer.getCOSDictionary(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        if (this.isLenient() && !root.containsKey(COSName.TYPE)) {
            root.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        }
        this.checkPages(root);
        this.document.setDecrypted();
        this.initialParseDone = true;
    }

    public PDDocument parse() throws IOException {
        return this.parse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDDocument parse(boolean lenient) throws IOException {
        this.setLenient(lenient);
        boolean exceptionOccurred = true;
        try {
            if (!this.parsePDFHeader() && !this.parseFDFHeader()) {
                if (lenient) {
                    LOG.warn("Error: Header doesn't contain versioninfo");
                } else {
                    throw new IOException("Error: Header doesn't contain versioninfo");
                }
            }
            if (!this.initialParseDone) {
                this.initialParse();
            }
            exceptionOccurred = false;
            PDDocument pdDocument = this.createDocument();
            pdDocument.setEncryptionDictionary(this.getEncryption());
            PDDocument pDDocument = pdDocument;
            return pDDocument;
        }
        finally {
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }

    protected PDDocument createDocument() throws IOException {
        return new PDDocument(this.document, this.source, this.getAccessPermission());
    }

    @Deprecated
    public static PDDocument load(File file) throws IOException {
        return Loader.loadPDF(file);
    }

    @Deprecated
    public static PDDocument load(File file, String password) throws IOException {
        return Loader.loadPDF(file, password);
    }
}

