/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.hexviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.pdfbox.debugger.hexviewer.HexEditor;
import org.apache.pdfbox.debugger.hexviewer.HexModel;

public class HexView {
    private final JComponent mainPane = new JPanel(new BorderLayout());
    static final int FONT_SIZE = ((Font)UIManager.get("Label.font")).getSize();
    static final Font FONT = new Font("monospaced", 0, FONT_SIZE);
    static final int CHAR_HEIGHT = 20;
    static final int CHAR_WIDTH = 35;
    static final int LINE_INSET = 20;
    static final Color SELECTED_COLOR = UIManager.getColor("textHighlight");
    static final Font BOLD_FONT = new Font("monospaced", 1, FONT_SIZE);
    static final int HEX_PANE_WIDTH = 600;
    static final int ADDRESS_PANE_WIDTH = 120;
    static final int ASCII_PANE_WIDTH = 270;
    static final int TOTAL_WIDTH = 990;
    static final Map<RenderingHints.Key, Object> RENDERING_HINTS = new HashMap<RenderingHints.Key, Object>();

    public HexView() {
    }

    public HexView(byte[] bytes) {
        this.mainPane.add(new HexEditor(new HexModel(bytes)));
    }

    public void changeData(byte[] bytes) {
        if (this.mainPane.getComponentCount() > 0) {
            this.mainPane.removeAll();
        }
        HexModel model = new HexModel(bytes);
        this.mainPane.add(new HexEditor(model));
        this.mainPane.validate();
    }

    public JComponent getPane() {
        return this.mainPane;
    }

    static {
        RENDERING_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RENDERING_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
    }
}

