/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.util.Matrix;

class Type3Font
extends FontPane {
    public static final String NO_GLYPH = "No glyph";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;
    private PDRectangle fontBBox;
    private final PDResources resources;

    Type3Font(PDType3Font font, PDResources resources) throws IOException {
        this.resources = resources;
        this.calcBBox(font);
        Object[][] tableData = this.getGlyphs(font);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Font", font.getName());
        attributes.put("Encoding", this.getEncodingName(font));
        attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
        this.view = new FontEncodingView(tableData, attributes, new String[]{"Code", "Glyph Name", "Unicode Character", "Glyph"}, null);
    }

    private void calcBBox(PDType3Font font) throws IOException {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (int index = 0; index <= 255; ++index) {
            PDRectangle glyphBBox;
            PDType3CharProc charProc = font.getCharProc(index);
            if (charProc == null || (glyphBBox = charProc.getGlyphBBox()) == null) continue;
            minX = Math.min(minX, (double)glyphBBox.getLowerLeftX());
            maxX = Math.max(maxX, (double)glyphBBox.getUpperRightX());
            minY = Math.min(minY, (double)glyphBBox.getLowerLeftY());
            maxY = Math.max(maxY, (double)glyphBBox.getUpperRightY());
        }
        this.fontBBox = new PDRectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
        if (this.fontBBox.getWidth() <= 0.0f || this.fontBBox.getHeight() <= 0.0f) {
            BoundingBox boundingBox = font.getBoundingBox();
            this.fontBBox = new PDRectangle(boundingBox.getLowerLeftX(), boundingBox.getLowerLeftY(), boundingBox.getWidth(), boundingBox.getHeight());
        }
    }

    private Object[][] getGlyphs(PDType3Font font) throws IOException {
        boolean isEmpty = this.fontBBox.toGeneralPath().getBounds2D().isEmpty();
        Object[][] glyphs = new Object[256][4];
        HashMap<String, BufferedImage> map = new HashMap<String, BufferedImage>();
        for (int index = 0; index <= 255; ++index) {
            glyphs[index][0] = index;
            if (font.getEncoding().contains(index) || font.toUnicode(index) != null) {
                String name = font.getEncoding().getName(index);
                glyphs[index][1] = name;
                glyphs[index][2] = font.toUnicode(index);
                if (isEmpty) {
                    glyphs[index][3] = NO_GLYPH;
                } else if (map.containsKey(name)) {
                    glyphs[index][3] = map.get(name);
                } else {
                    BufferedImage image = this.renderType3Glyph(font, index);
                    map.put(name, image);
                    glyphs[index][3] = image;
                }
                ++this.totalAvailableGlyph;
                continue;
            }
            glyphs[index][1] = NO_GLYPH;
            glyphs[index][2] = NO_GLYPH;
            glyphs[index][3] = NO_GLYPH;
        }
        return glyphs;
    }

    private BufferedImage renderType3Glyph(PDType3Font font, int index) throws IOException {
        try (PDDocument doc = new PDDocument();){
            int scale = 1;
            if (this.fontBBox.getWidth() < 72.0f || this.fontBBox.getHeight() < 72.0f) {
                scale = (int)(72.0f / Math.min(this.fontBBox.getWidth(), this.fontBBox.getHeight()));
            }
            PDPage page = new PDPage(new PDRectangle(this.fontBBox.getWidth() * (float)scale, this.fontBBox.getHeight() * (float)scale));
            page.setResources(this.resources);
            try (PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, false);){
                float scalingFactorX = font.getFontMatrix().getScalingFactorX();
                float scalingFactorY = font.getFontMatrix().getScalingFactorY();
                float translateX = scalingFactorX > 0.0f ? -this.fontBBox.getLowerLeftX() : this.fontBBox.getUpperRightX();
                float translateY = scalingFactorY > 0.0f ? -this.fontBBox.getLowerLeftY() : this.fontBBox.getUpperRightY();
                cs.transform(Matrix.getTranslateInstance(translateX * (float)scale, translateY * (float)scale));
                cs.beginText();
                cs.setFont(font, (float)scale / Math.min(Math.abs(scalingFactorX), Math.abs(scalingFactorY)));
                cs.appendRawCommands(String.format("<%02X> Tj%n", index).getBytes(StandardCharsets.ISO_8859_1));
                cs.endText();
            }
            doc.addPage(page);
            BufferedImage bufferedImage = new PDFRenderer(doc).renderImage(0);
            return bufferedImage;
        }
    }

    private String getEncodingName(PDType3Font font) {
        return font.getEncoding().getClass().getSimpleName() + " / " + font.getEncoding().getEncodingName();
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }
}

