/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter.compress;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfwriter.compress.COSObjectPool;
import org.apache.pdfbox.pdfwriter.compress.COSWriterObjectStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdfwriter.compress.TraversedCOSElement;
import org.apache.pdfbox.pdmodel.PDDocument;

public class COSWriterCompressionPool {
    public static final float MINIMUM_SUPPORTED_VERSION = 1.6f;
    private final PDDocument document;
    private final CompressParameters parameters;
    private final COSObjectPool objectPool;
    private final List<COSObjectKey> topLevelObjects = new ArrayList<COSObjectKey>();
    private final List<COSObjectKey> objectStreamObjects = new ArrayList<COSObjectKey>();

    public COSWriterCompressionPool(PDDocument document, CompressParameters parameters) throws IOException {
        this.document = document;
        this.parameters = parameters != null ? parameters : new CompressParameters();
        this.objectPool = new COSObjectPool(document.getDocument().getHighestXRefObjectNumber());
        COSDocument cosDocument = document.getDocument();
        COSDictionary trailer = cosDocument.getTrailer();
        this.addStructure(new TraversedCOSElement(trailer.getItem(COSName.ROOT)));
        this.addStructure(new TraversedCOSElement(trailer.getItem(COSName.INFO)));
        Collections.sort(this.objectStreamObjects);
        Collections.sort(this.topLevelObjects);
    }

    private COSBase addObjectToPool(COSObjectKey key, TraversedCOSElement element) {
        COSBase base = element.getCurrentObject();
        COSBase cOSBase = base = base instanceof COSObject ? ((COSObject)base).getObject() : base;
        if (base == null || this.objectPool.contains(base)) {
            return base;
        }
        if (key != null && key.getGeneration() != 0 || this.document.getEncryption() != null && base == this.document.getEncryption().getCOSObject() || base == this.document.getDocument().getTrailer().getCOSDictionary(COSName.ROOT) || base instanceof COSStream) {
            COSObjectKey actualKey = this.objectPool.put(key, base);
            if (actualKey == null) {
                return base;
            }
            this.topLevelObjects.add(actualKey);
            return base;
        }
        COSObjectKey actualKey = this.objectPool.put(key, base);
        if (actualKey == null) {
            return base;
        }
        this.objectStreamObjects.add(actualKey);
        return base;
    }

    private COSBase addStructure(TraversedCOSElement traversedObject) throws IOException {
        COSBase current;
        COSBase base = current = traversedObject.getCurrentObject();
        COSBase retVal = current;
        if (current instanceof COSStream || current instanceof COSDictionary && !current.isDirect()) {
            retVal = base = this.addObjectToPool(base.getKey(), traversedObject);
        } else if (current instanceof COSObject) {
            base = ((COSObject)current).getObject();
            if (base instanceof COSDictionary || base instanceof COSArray) {
                base = this.addObjectToPool(current.getKey(), traversedObject);
            } else {
                retVal = base;
            }
        }
        if (base instanceof COSArray) {
            this.addCOSArray(traversedObject, (COSArray)base);
        } else if (base instanceof COSDictionary) {
            this.addCOSDictionary(traversedObject, (COSDictionary)base);
        }
        return retVal;
    }

    private void addCOSArray(TraversedCOSElement traversedObject, COSArray array) throws IOException {
        for (COSBase value : array) {
            if (!(value instanceof COSDictionary) && !(value instanceof COSObject) && !(value instanceof COSArray) || traversedObject.getAllTraversedObjects().contains(value)) continue;
            this.addStructure(traversedObject.appendTraversedElement(value));
        }
    }

    private void addCOSDictionary(TraversedCOSElement traversedObject, COSDictionary dictionary) throws IOException {
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value = entry.getValue();
            if (!(value instanceof COSDictionary) && !(value instanceof COSObject) && !(value instanceof COSArray) || traversedObject.getAllTraversedObjects().contains(value)) continue;
            this.addStructure(traversedObject.appendTraversedElement(value));
        }
    }

    public List<COSObjectKey> getTopLevelObjects() {
        return this.topLevelObjects;
    }

    public List<COSObjectKey> getObjectStreamObjects() {
        return this.objectStreamObjects;
    }

    public boolean contains(COSBase object) {
        return this.objectPool.contains(object);
    }

    public COSObjectKey getKey(COSBase object) {
        return this.objectPool.getKey(object);
    }

    public COSBase getObject(COSObjectKey key) {
        return this.objectPool.getObject(key);
    }

    public long getHighestXRefObjectNumber() {
        return this.objectPool.getHighestXRefObjectNumber();
    }

    public List<COSWriterObjectStream> createObjectStreams() {
        ArrayList<COSWriterObjectStream> objectStreams = new ArrayList<COSWriterObjectStream>();
        COSWriterObjectStream objectStream = null;
        for (int i = 0; i < this.objectStreamObjects.size(); ++i) {
            COSObjectKey key = this.objectStreamObjects.get(i);
            if (objectStream == null || i % this.parameters.getObjectStreamSize() == 0) {
                objectStream = new COSWriterObjectStream(this);
                objectStreams.add(objectStream);
            }
            objectStream.prepareStreamObject(key, this.objectPool.getObject(key));
        }
        return objectStreams;
    }
}

