/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;

public class FDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(FDFParser.class);

    public FDFParser(RandomAccessRead source) throws IOException {
        super(source);
        this.init();
    }

    @Override
    protected final boolean isCatalog(COSDictionary dictionary) {
        return dictionary.containsKey(COSName.FDF);
    }

    private void init() {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'");
            }
        }
        this.document = new COSDocument(this);
    }

    private void initialParse() throws IOException {
        COSDictionary trailer = this.retrieveTrailer();
        COSDictionary root = trailer.getCOSDictionary(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        this.initialParseDone = true;
    }

    public FDFDocument parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            this.initialParse();
            exceptionOccurred = false;
            FDFDocument fDFDocument = new FDFDocument(this.document);
            return fDFDocument;
        }
        finally {
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }
}

