/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

public class RandomAccessReadMemoryMappedFile
implements RandomAccessRead {
    private ByteBuffer mappedByteBuffer;
    private final long size;
    private FileChannel fileChannel;
    private Consumer<? super ByteBuffer> unmapper = IOUtils::unmap;

    public RandomAccessReadMemoryMappedFile(String filename) throws IOException {
        this(new File(filename));
    }

    public RandomAccessReadMemoryMappedFile(File file) throws IOException {
        this.fileChannel = FileChannel.open(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);
        this.size = this.fileChannel.size();
        if (this.size > Integer.MAX_VALUE) {
            throw new IOException(this.getClass().getName() + " doesn't yet support files bigger than " + Integer.MAX_VALUE);
        }
        this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.size);
    }

    private RandomAccessReadMemoryMappedFile(RandomAccessReadMemoryMappedFile parent) {
        this.mappedByteBuffer = parent.mappedByteBuffer.duplicate();
        this.size = parent.size;
        this.mappedByteBuffer.rewind();
        this.unmapper = null;
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
        Optional.ofNullable(this.unmapper).ifPresent(u -> u.accept(this.mappedByteBuffer));
        this.mappedByteBuffer = null;
    }

    @Override
    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IOException("Invalid position " + position);
        }
        this.mappedByteBuffer.position((int)Math.min(position, this.size));
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.mappedByteBuffer.position();
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.mappedByteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        int remainingBytes = (int)this.size - this.mappedByteBuffer.position();
        this.mappedByteBuffer.get(b, offset, Math.min(remainingBytes, length));
        return Math.min(remainingBytes, length);
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.size;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException(this.getClass().getSimpleName() + " already closed");
        }
    }

    @Override
    public boolean isClosed() {
        return this.mappedByteBuffer == null;
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return (long)this.mappedByteBuffer.position() >= this.size;
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) {
        return new RandomAccessReadView(new RandomAccessReadMemoryMappedFile(this), startPosition, streamLength, true);
    }
}

