/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.ICOSParser;
import org.apache.pdfbox.cos.ICOSVisitor;

public class COSObject
extends COSBase
implements COSUpdateInfo {
    private COSBase baseObject;
    private long objectNumber;
    private int generationNumber;
    private boolean needToBeUpdated;
    private ICOSParser parser;
    private boolean isDereferenced = false;
    private static final Log LOG = LogFactory.getLog(COSObject.class);

    public COSObject(COSBase object) {
        this.baseObject = object;
    }

    public COSObject(COSBase object, COSObjectKey objectKey) {
        this(objectKey, null);
        this.baseObject = object;
    }

    public COSObject(COSBase object, ICOSParser parser) {
        this.baseObject = object;
        this.parser = parser;
    }

    public COSObject(COSObjectKey key, ICOSParser parser) {
        this.parser = parser;
        this.objectNumber = key.getNumber();
        this.generationNumber = key.getGeneration();
        this.setKey(key);
    }

    public boolean isObjectNull() {
        return this.baseObject == null;
    }

    public COSBase getObject() {
        if (!this.isDereferenced && this.parser != null) {
            try {
                this.isDereferenced = true;
                this.baseObject = this.parser.dereferenceCOSObject(this);
            }
            catch (IOException e) {
                LOG.error("Can't dereference " + this, e);
            }
            finally {
                this.parser = null;
            }
        }
        return this.baseObject;
    }

    public final void setToNull() {
        this.baseObject = COSNull.NULL;
        this.parser = null;
    }

    public String toString() {
        return "COSObject{" + this.objectNumber + ", " + this.generationNumber + "}";
    }

    public long getObjectNumber() {
        return this.objectNumber;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        COSBase object = this.getObject();
        return object != null ? object.accept(visitor) : COSNull.NULL.accept(visitor);
    }

    @Override
    public boolean isNeedToBeUpdated() {
        return this.needToBeUpdated;
    }

    @Override
    public void setNeedToBeUpdated(boolean flag) {
        this.needToBeUpdated = flag;
    }
}

