/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fontbox.ttf.gsub.CompoundCharacterTokenizer;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitter;

public class GlyphArraySplitterRegexImpl
implements GlyphArraySplitter {
    private static final String GLYPH_ID_SEPARATOR = "_";
    private final CompoundCharacterTokenizer compoundCharacterTokenizer;

    public GlyphArraySplitterRegexImpl(Set<List<Integer>> matchers) {
        this.compoundCharacterTokenizer = new CompoundCharacterTokenizer(this.getMatchersAsStrings(matchers));
    }

    @Override
    public List<List<Integer>> split(List<Integer> glyphIds) {
        String originalGlyphsAsText = this.convertGlyphIdsToString(glyphIds);
        List<String> tokens = this.compoundCharacterTokenizer.tokenize(originalGlyphsAsText);
        ArrayList<List<Integer>> modifiedGlyphs = new ArrayList<List<Integer>>(tokens.size());
        tokens.forEach(token -> modifiedGlyphs.add(this.convertGlyphIdsToList((String)token)));
        return modifiedGlyphs;
    }

    private Set<String> getMatchersAsStrings(Set<List<Integer>> matchers) {
        HashSet<String> stringMatchers = new HashSet<String>(matchers.size());
        matchers.forEach(glyphIds -> stringMatchers.add(this.convertGlyphIdsToString((List<Integer>)glyphIds)));
        return stringMatchers;
    }

    private String convertGlyphIdsToString(List<Integer> glyphIds) {
        StringBuilder sb = new StringBuilder(20);
        sb.append(GLYPH_ID_SEPARATOR);
        glyphIds.forEach(glyphId -> sb.append(glyphId).append(GLYPH_ID_SEPARATOR));
        return sb.toString();
    }

    private List<Integer> convertGlyphIdsToList(String glyphIdsAsString) {
        ArrayList<Integer> gsubProcessedGlyphsIds = new ArrayList<Integer>();
        for (String glyphId : glyphIdsAsString.split(GLYPH_ID_SEPARATOR)) {
            if ((glyphId = glyphId.trim()).isEmpty()) continue;
            gsubProcessedGlyphsIds.add(Integer.valueOf(glyphId));
        }
        return gsubProcessedGlyphsIds;
    }
}

